/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.caching;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.caching.FlybitsUIListObserver;
import java.util.List;

public class ContentCacheObserver
extends FlybitsUIListObserver<Content> {
    private static ContentCacheObserver INSTANCE = null;

    private ContentCacheObserver(Context context) {
        super(context);
    }

    public void onLoad(List<String> cachingIds) {
        this.setItems(KernelDatabase.getDatabase(this.getContext()).contentDao().getLiveByIdList(cachingIds));
    }

    public void add(@NonNull String key, FlybitsUIListObserver.DataChanged<Content> callback) {
        super.add(key, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentCacheObserver observe(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<ContentCacheObserver> clazz = ContentCacheObserver.class;
        synchronized (ContentCacheObserver.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ContentCacheObserver(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void remove() {
        super.remove();
        if (this.getData() != null && !this.getData().hasActiveObservers()) {
            INSTANCE = null;
        }
    }
}

