package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * A single Answer to be submitted to a Survey, within a {@code SurveyAnswer} object. It contains
 * a question number (provided from {@code Question} and a list of answers. The answers can be
 * either a single value (for input and single choice questions), or multiple values (for multi choice
 * questions).
 */
public class Answer implements Parcelable {

    public Long questionNumber;
    public ArrayList<String> answer = new ArrayList<>();;

    /**
     * Instantiates a {@code Answer} object set to it's question number.
     * @param questionNumber question number of the survey question
     */
    public Answer(long questionNumber){
        this.questionNumber = questionNumber;
    }

    /**
     * Adds a new answer to the answer list.
     * @param newAnswer The
     */
    public void addAnswer(String newAnswer)
    {
        answer.add(newAnswer);
    }

    /**
     * Clears the answer list.
     */
    public void clearAnswers()
    {
        answer.clear();
    }

    /**
     * Returns this object serialized into JSON.
     * @return This object as JSON.
     * @throws JSONException is thrown when there was an issue with serialization.
     */
    public String getJSON() throws JSONException {
        JSONObject root = new JSONObject();
        JSONArray answersArray = new JSONArray();

        root.put("questionNumber", questionNumber);
        root.put("answer", answersArray);

        for (String value : answer)
            answersArray.put(value);

        return root.toString();
    }

    public Answer(Parcel in) {
        questionNumber = in.readLong();
        in.readStringList(answer);
    }

    public static final Creator<Answer> CREATOR = new Creator<Answer>() {
        @Override
        public Answer createFromParcel(Parcel in) {
            return new Answer(in);
        }

        @Override
        public Answer[] newArray(int size) {
            return new Answer[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(questionNumber);
        dest.writeStringList(answer);
    }

}
