package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Transaction;

import com.flybits.android.kernel.models.Content;

import java.util.List;

import static android.arch.persistence.room.OnConflictStrategy.REPLACE;

@Dao
//TODO: Missing Comments
public abstract class ContentDao {

    /**
     * Get Requests
     */
    @Query("SELECT * FROM content WHERE id = :id")
    public abstract Content getById(String id);

    @Query("SELECT * FROM content")
    public abstract List<Content> getAll();

    @Query("SELECT * FROM content WHERE id IN (:ids)")
    public abstract List<Content> getByCachedIds(List<String> ids);

    @Query("SELECT * FROM content WHERE id IN (:ids) LIMIT :limit")
    public abstract List<Content> getByCachedIds(List<String> ids, int limit);

    @Query("SELECT * FROM content WHERE templateId = :templateId")
    public abstract List<Content> getAllByTemplateId(String templateId);

    /**
     * BASIC CRUD
     */
    @Insert(onConflict = REPLACE)
    public abstract void insert(List<Content> content);

    @Query("DELETE FROM content")
    public abstract void clear();

    @Query("DELETE FROM content WHERE id IN (:ids)")
    public abstract void deleteByIds(List<String> ids);

    /**
     * LIVE DATA
     */
    @Query("SELECT * FROM content")
    public abstract LiveData<List<Content>> getLive();

    @Query("SELECT * FROM content WHERE id IN (:ids)")
    public abstract LiveData<List<Content>> getLiveByCacheIds(List<String> ids);

    @Query("SELECT * FROM content WHERE id = :id")
    public abstract LiveData<List<Content>> getLiveById(String id);

    @Query("SELECT * FROM content WHERE templateId = :templateId")
    public abstract LiveData<List<Content>> getLiveAllByTemplateId(String templateId);

    @Transaction
    public void insertAndDeleteInTransaction(List<String> deleteContentIds, List<Content> insertContent) {
        // Anything inside this method runs in a single transaction.
        deleteByIds(deleteContentIds);
        insert(insertContent);
    }
}
