/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.activity;

import android.app.IntentService;
import android.content.Intent;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.activity.ActivityData;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;
import java.util.List;

public class DeviceRecognitionServiceIntent
extends IntentService {
    private static final String TAG_DEVICE = "DeviceRecognitionServiceIntent";

    public DeviceRecognitionServiceIntent() {
        super(TAG_DEVICE);
    }

    protected void onHandleIntent(Intent intent) {
        Logger.appendTag((String)TAG_DEVICE).d("DeviceRecognitionServiceIntent() - Start");
        ActivityData data = this.processIntent(intent);
        if (data != null) {
            Logger.appendTag((String)TAG_DEVICE).d("Received Data: " + data.toString());
            long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
            data.update(this.getBaseContext(), timeInSec, null);
        }
        Logger.appendTag((String)TAG_DEVICE).d("DeviceRecognitionServiceIntent() - End");
    }

    ActivityData processIntent(Intent intent) {
        if (ActivityRecognitionResult.hasResult((Intent)intent)) {
            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult((Intent)intent);
            boolean driving = false;
            boolean cycling = false;
            boolean stationary = false;
            boolean running = false;
            boolean walking = false;
            boolean unknown = false;
            List detectedActivity = result.getProbableActivities();
            block7: for (DetectedActivity activity : detectedActivity) {
                if (activity.getConfidence() <= 10) continue;
                switch (this.getActivityName(activity.getType())) {
                    case IN_VEHICLE: {
                        driving = true;
                        continue block7;
                    }
                    case ON_BICYCLE: {
                        cycling = true;
                        continue block7;
                    }
                    case STILL: {
                        stationary = true;
                        continue block7;
                    }
                    case RUNNING: {
                        running = true;
                        continue block7;
                    }
                    case WALKING: {
                        walking = true;
                        continue block7;
                    }
                }
                unknown = true;
            }
            return new ActivityData(cycling, driving, running, stationary, walking, unknown);
        }
        Logger.appendTag((String)TAG_DEVICE).e("Intent had no data returned");
        return null;
    }

    ActivityData.ActivityType getActivityName(int type) {
        switch (type) {
            case 0: {
                return ActivityData.ActivityType.IN_VEHICLE;
            }
            case 1: {
                return ActivityData.ActivityType.ON_BICYCLE;
            }
            case 2: {
                return ActivityData.ActivityType.WALKING;
            }
            case 7: {
                return ActivityData.ActivityType.WALKING;
            }
            case 3: {
                return ActivityData.ActivityType.STILL;
            }
            case 5: {
                return ActivityData.ActivityType.STILL;
            }
            case 8: {
                return ActivityData.ActivityType.RUNNING;
            }
            case 4: {
                return ActivityData.ActivityType.UNKNOWN;
            }
        }
        return ActivityData.ActivityType.UNKNOWN;
    }
}

