/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.activity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.activity.ActivityData;
import com.flybits.context.plugins.activity.ActivityRecognitionBroadcast$WhenMappings;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/flybits/context/plugins/activity/ActivityRecognitionBroadcast;", "Landroid/content/BroadcastReceiver;", "()V", "tagDevice", "", "getActivityName", "Lcom/flybits/context/plugins/activity/ActivityData$ActivityType;", "type", "", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "processIntent", "Lcom/flybits/context/plugins/activity/ActivityData;", "context_release"})
public final class ActivityRecognitionBroadcast
extends BroadcastReceiver {
    private final String tagDevice;

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block0: {
            ActivityData data;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            Logger.appendTag((String)this.tagDevice).d("Fetching Data ... ");
            ActivityData activityData = data = this.processIntent(intent);
            if (activityData == null) break block0;
            ActivityData activityData2 = activityData;
            boolean bl = false;
            boolean bl2 = false;
            ActivityData it = activityData2;
            boolean bl3 = false;
            Logger.appendTag((String)this.tagDevice).d("Received Data: " + data);
            long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / (long)1000;
            data.update(context, timeInSec);
        }
    }

    private final ActivityData processIntent(Intent intent) {
        if (ActivityRecognitionResult.hasResult((Intent)intent)) {
            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult((Intent)intent);
            boolean driving = false;
            boolean cycling = false;
            boolean stationary = false;
            boolean running = false;
            boolean walking = false;
            boolean unknown = false;
            ActivityRecognitionResult activityRecognitionResult = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)activityRecognitionResult, (String)"result");
            List detectedActivity = activityRecognitionResult.getProbableActivities();
            Iterator iterator = detectedActivity.iterator();
            block7: while (iterator.hasNext()) {
                DetectedActivity activity;
                DetectedActivity detectedActivity2 = activity = (DetectedActivity)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)detectedActivity2, (String)"activity");
                if (detectedActivity2.getConfidence() <= 10) continue;
                switch (ActivityRecognitionBroadcast$WhenMappings.$EnumSwitchMapping$0[this.getActivityName(activity.getType()).ordinal()]) {
                    case 1: {
                        driving = true;
                        continue block7;
                    }
                    case 2: {
                        cycling = true;
                        continue block7;
                    }
                    case 3: {
                        stationary = true;
                        continue block7;
                    }
                    case 4: {
                        running = true;
                        continue block7;
                    }
                    case 5: {
                        walking = true;
                        continue block7;
                    }
                }
                unknown = true;
            }
            return new ActivityData(cycling, driving, running, stationary, walking, unknown);
        }
        Logger.appendTag((String)this.tagDevice).e("Intent had no data returned");
        return null;
    }

    private final ActivityData.ActivityType getActivityName(int type) {
        ActivityData.ActivityType activityType;
        switch (type) {
            case 0: {
                activityType = ActivityData.ActivityType.IN_VEHICLE;
                break;
            }
            case 1: {
                activityType = ActivityData.ActivityType.ON_BICYCLE;
                break;
            }
            case 2: {
                activityType = ActivityData.ActivityType.WALKING;
                break;
            }
            case 7: {
                activityType = ActivityData.ActivityType.WALKING;
                break;
            }
            case 3: {
                activityType = ActivityData.ActivityType.STILL;
                break;
            }
            case 5: {
                activityType = ActivityData.ActivityType.STILL;
                break;
            }
            case 8: {
                activityType = ActivityData.ActivityType.RUNNING;
                break;
            }
            case 4: {
                activityType = ActivityData.ActivityType.UNKNOWN;
                break;
            }
            default: {
                activityType = ActivityData.ActivityType.UNKNOWN;
            }
        }
        return activityType;
    }

    public ActivityRecognitionBroadcast() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.javaClass.simpleName");
        this.tagDevice = string;
    }
}

