package com.flybits.context.plugins.carrier

import android.Manifest
import android.content.Context
import android.os.Bundle
import android.telephony.TelephonyManager
import androidx.work.WorkerParameters
import com.flybits.commons.library.logging.Logger
import com.flybits.context.models.ContextData
import com.flybits.context.services.FlybitsContextPluginsWorker

const val TAG = "PluginCarrier"

/**
 * The [CarrierContextPluginWorker] is a worker responsible for retrieving the Carrier used.
 * This will be triggered by `WorkManager` on start of carrier plugin to fetch the carrier information used after specified interval.
 * The minimum interval for the worker to execute is 900 seconds.
 * Permissions required are : READ_PHONE_STATE.
 */
class CarrierContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {

    override fun getData(): ContextData {
        Logger.appendTag(TAG).d("Fetching Carrier Data... ")
        val tel = applicationContext.getSystemService(Context.TELEPHONY_SERVICE)
        return if (tel is TelephonyManager) {
            val simOperator = tel.simOperator
            CarrierData(simOperator)
        } else throw NullPointerException("getSystemService() returns null")
    }

    override fun getRequiredPermissions(): Array<String> {
        return arrayOf(Manifest.permission.READ_PHONE_STATE)
    }

    override fun initialize(bundle: Bundle?) {
    }

    override fun isSupported(): Boolean {
        return true
    }
}