package com.flybits.context.plugins.activity

import android.Manifest
import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.work.Worker

import androidx.work.WorkerParameters
import com.flybits.context.models.ContextData
import com.flybits.context.plugins.battery.TAG
import com.flybits.context.services.FlybitsContextPluginsWorker
import com.flybits.commons.library.logging.Logger

/**
 * The [ActivityContextPluginWorker] is a [Worker] responsible for retrieving the Activity Information.
 * This will be triggered by `WorkManager` on start of Activity plugin to fetch the motion and status after specified interval.
 * The minimum interval for the worker to execute is 30 seconds.
 */
class ActivityContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {

    override fun getData(): ContextData {
        return ActivityData()
    }

    override fun getRequiredPermissions(): Array<String> {
        return if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
            //Android 9 (API level 28) or lower, the system auto-grants the android.permission.ACTIVITY_RECOGNITION permission
            arrayOf(
                Manifest.permission.ACTIVITY_RECOGNITION
            )
        } else {
            arrayOf()
        }
    }

    override fun initialize(bundle: Bundle?) {
        Logger.appendTag(TAG).d("Start ActivityContextPluginWorker...")
        val jobIntent = Intent(applicationContext, ActivityRecognitionJobIntent::class.java)
        ActivityRecognitionJobIntent.enqueueWork(applicationContext, jobIntent)
    }

    override fun isSupported(): Boolean {
        return true
    }
}