package com.flybits.context;

import com.flybits.context.models.RuleEvalutated;

/**
 * Context SDK's Constants Class for storing all API, Broadcast, and SDK constants that are pre-set
 * and used throughout the SDK. These will Constants will not change.
 */
public class FlyingContextConstants {

    /*
        Broadcast Constants
     */
    /**
     * Indicates the Broadcast Action that is initialized whenever the
     * {@link RuleEvalutated#isLastResult()} has been updated from true to false, or
     * false to true.
     */
    public static final String BROADCAST_RULE_CHANGED                   = "com.flybits.broadcasts.rule.status.UPDATED";

    /**
     * Indicates the object parameter that contains the newly updated {@link RuleEvalutated}
     * including the updated {@link RuleEvalutated#isLastResult()}.
     */
    public static final String BROADCAST_RULE_CHANGED_PARAM_RULE        = "com.flybits.broadcasts.extras.RULE";

    /**
     * Indicates that {@link com.flybits.context.models.ContextData} of a plugin has been updated.
     * Included in this action is the {@link com.flybits.context.models.ContextData} itself along
     * with the time in milliseconds when the update occurred.
     */
    public static final String BROADCAST_CONTEXT_UPDATE                 = "com.flybits.broadcasts.context.status.UPDATED";

    /**
     * Indicates the TIME extra for {@link #BROADCAST_CONTEXT_UPDATE} broadcasts which indicates
     * when data associated to broadcast was updated.
     */
    public static final String BROADCAST_CONTEXT_UPDATE_EXTRA_TIME      = "com.flybits.broadcasts.context.extras.TIME";

    /**
     * Indicates the DATA extra for {@link #BROADCAST_CONTEXT_UPDATE} broadcasts which indicates
     * when the data that was just updated.
     */
    public static final String BROADCAST_CONTEXT_UPDATE_EXTRA_DATA      = "com.flybits.broadcasts.context.extras.DATA";

    /**
     * Indicates the PLUGIN extra for {@link #BROADCAST_CONTEXT_UPDATE} broadcasts which indicates
     * which {@code Plugin} has been updated.
     */
    public static final String BROADCAST_CONTEXT_UPDATE_EXTRA_PLUGIN    = "com.flybits.broadcasts.context.extras.PLUGIN";
}
