/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.work.Constraints;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidParameterException;
import com.flybits.commons.library.exceptions.NetworkResponseException;
import com.flybits.commons.library.exceptions.NotConnectedException;
import com.flybits.commons.library.exceptions.UserOptedOutException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Displayer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextPluginsService;
import com.flybits.context.ContextRulesService;
import com.flybits.context.ContextScope;
import com.flybits.context.ContextUploadingService;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.BasicData;
import com.flybits.context.models.ContextData;
import com.flybits.context.models.ContextPriority;
import com.flybits.context.plugins.FlybitsContextPlugin;
import com.flybits.context.services.FlybitsContextPluginService;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import com.flybits.context.utils.ContextUtilities;
import com.flybits.context.workers.ContextUploadingWorker;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.UserDAO;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007JH\u0010\u0012\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00182\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0019H\u0007JH\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00182\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0019H\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u001c\u0010%\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u001a\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0003J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J0\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0016\u0010)\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0*2\u0006\u0010+\u001a\u00020,H\u0007J(\u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0007J0\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020\u001c2\u0006\u00105\u001a\u00020,H\u0007J\u0018\u00106\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\"\u00109\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0010\u0010<\u001a\u00020\u001c2\u0006\u00105\u001a\u00020,H\u0002J\u0018\u0010=\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u0018\u0010>\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u0018\u0010?\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u0018\u0010@\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001fH\u0007J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J\b\u0010C\u001a\u00020\u001cH\u0007J\u0010\u0010C\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/flybits/context/ContextManager;", "", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "job", "Lkotlinx/coroutines/CompletableJob;", "exceptionHandlerBuilder", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "text", "", "flushContextData", "", "context", "Landroid/content/Context;", "Lcom/flybits/commons/library/api/results/BasicResult;", "callback", "Lcom/flybits/commons/library/api/results/callbacks/BasicResultCallback;", "getData", "Lcom/flybits/commons/library/api/results/ObjectResult;", "T", "Lcom/flybits/context/models/ContextData;", "pluginID", "subclass", "Ljava/lang/Class;", "Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;", "getDataPrivate", "pause", "", "mContext", "flybitsContextPlugin", "Lcom/flybits/context/plugins/FlybitsContextPlugin;", "pauseAll", "pauseAllSync", "pauseSync", "refresh", "plugin", "refreshAll", "refreshAllSync", "refreshSync", "registerForPluginUpdates", "listOfClass", "Ljava/util/HashMap;", "timeToRefreshInSec", "", "registerForRules", "timeInSeconds", "timeInSecondsFlex", "unit", "Ljava/util/concurrent/TimeUnit;", "registerUploadingContext", "priority", "Lcom/flybits/context/models/ContextPriority;", "time", "resume", "resumeAll", "resumeAllSync", "resumeSync", "user", "Lcom/flybits/commons/library/models/User;", "scheduleWorker", "start", "startSync", "stop", "stopSync", "unregisterFromRuleCollection", "unregisterPluginContext", "unregisterUploadingContext", "context_release"})
public final class ContextManager {
    private static final CompletableJob job;
    private static final CoroutineScope coroutineScope;
    public static final ContextManager INSTANCE;

    private final CoroutineExceptionHandler exceptionHandlerBuilder(String text) {
        boolean $i$f$CoroutineExceptionHandler = false;
        return new CoroutineExceptionHandler((CoroutineContext.Key)CoroutineExceptionHandler.Key, text){
            final /* synthetic */ String $text$inlined;
            {
                this.$text$inlined = string;
                super($super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                Throwable throwable = exception;
                CoroutineContext $noName_0 = context;
                boolean bl = false;
                Logger.appendTag((String)"CtxManager").e(this.$text$inlined);
            }
        };
    }

    static /* synthetic */ CoroutineExceptionHandler exceptionHandlerBuilder$default(ContextManager contextManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Error executing the CoroutineScope";
        }
        return contextManager.exceptionHandlerBuilder(string);
    }

    @JvmStatic
    @Nullable
    public static final <T extends ContextData> ObjectResult<T> getData(@NotNull Context context, @NotNull String pluginID, @NotNull Class<T> subclass, @Nullable ObjectResultCallback<T> callback) throws InvalidParameterException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pluginID, (String)"pluginID");
        Intrinsics.checkParameterIsNotNull(subclass, (String)"subclass");
        try {
            T t = subclass.newInstance();
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            ContextData cfr_ignored_0 = (ContextData)t;
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                throw (Throwable)new InstantiationException("The .Class file that will be instantiated must contain a constructor with no parameter for this method to be successfully processed");
            }
            throw (Throwable)new FlybitsException(e.getMessage());
        }
        return ContextManager.getDataPrivate(context, pluginID, subclass, callback);
    }

    @JvmStatic
    @NotNull
    public static final BasicResult flushContextData(@NotNull Context context, @Nullable BasicResultCallback callback) {
        ExecutorService executorService;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService2 = executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService2, (String)"executorService");
        BasicResult basicResult = new BasicResult(callback, handler, executorService2);
        executorService.execute(new Runnable(context, basicResult){
            final /* synthetic */ Context $context;
            final /* synthetic */ BasicResult $basicResult;

            public final void run() {
                boolean isSuccessful = ContextManager.flushContextData(this.$context);
                this.$basicResult.setResult(isSuccessful ? new Result(200, "") : new Result((FlybitsException)new NetworkResponseException("Error Updating Context"), ""));
            }
            {
                this.$context = context;
                this.$basicResult = basicResult;
            }
        });
        return basicResult;
    }

    @JvmStatic
    public static final boolean flushContextData(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean isSuccessful = false;
        List<BasicData> dataPlugins = ContextDatabase.Companion.getDatabase(context).basicDataDao().getAllNotSent();
        String jsonToSend = ContextUtilities.getContextData(dataPlugins);
        if (jsonToSend != null && jsonToSend.length() > 2) {
            try {
                Result result = FlyAway.post((Context)context, (String)"/context/ctxdata", (String)jsonToSend, null, (String)"FlushUtilities.flushContext", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"FlyAway.post<Any>(\n     \u2026ull\n                    )");
                Result result2 = result;
                if (result2.getStatus() == RequestStatus.COMPLETED) {
                    List<BasicData> list = dataPlugins;
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"dataPlugins");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BasicData it = (BasicData)element$iv;
                        boolean bl = false;
                        BasicData basicData = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicData, (String)"it");
                        basicData.setSent(true);
                        ContextDatabase.Companion.getDatabase(context).basicDataDao().update(it);
                    }
                    isSuccessful = true;
                } else {
                    Logger.appendTag((String)"CtxManager").e("Sending Flybits' ContextPlugin data to Server Failed.");
                }
            }
            catch (Exception e) {
                Logger.exception((String)"ContextManager.flushContextData", (Exception)e);
            }
        }
        return isSuccessful;
    }

    @JvmStatic
    public static final void refresh(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error refresh the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, plugin, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;
            final /* synthetic */ FlybitsContextPlugin $plugin;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.refreshSync(this.$mContext, this.$plugin);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                this.$plugin = flybitsContextPlugin;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void refreshSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        UserDAO userDAO = CommonsDatabase.getDatabase((Context)mContext).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(mContext).userDao()");
        User user2 = user = userDAO.getActiveUser();
        if (user2 != null) {
            User user3 = user2;
            boolean bl = false;
            boolean bl2 = false;
            User it = user3;
            boolean bl3 = false;
            if (it.isOptedIn()) {
                Logger.appendTag((String)"CtxManager").d("Refreshing Context Plugins");
                plugin.onRefresh(mContext);
            }
        }
        ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
    }

    @JvmStatic
    public static final void refreshAll(@Nullable Context mContext, @Nullable BasicResultCallback callback) {
        block3: {
            Object object;
            block2: {
                object = mContext;
                if (object == null) break block2;
                Context context = object;
                boolean bl = false;
                boolean bl2 = false;
                Context it = context;
                boolean bl3 = false;
                Job job = BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error refresh all the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, callback){
                    private CoroutineScope p$;
                    int label;
                    final /* synthetic */ Context $it;
                    final /* synthetic */ BasicResultCallback $callback$inlined;
                    {
                        this.$it = context;
                        this.$callback$inlined = basicResultCallback;
                        super(2, continuation);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$launch = this.p$;
                                ContextManager.access$refreshAllSync(this.$it, this.$callback$inlined);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                        function2.p$ = (CoroutineScope)value;
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                object = job;
                if (job != null) break block3;
            }
            object = Logger.appendTag((String)"CtxManager").e("The Context parameter cannot be null.");
        }
    }

    @JvmStatic
    private static final void refreshAllSync(Context mContext, BasicResultCallback callback) {
        boolean bl;
        UserDAO userDAO = CommonsDatabase.getDatabase((Context)mContext).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(mContext).userDao()");
        User user = userDAO.getActiveUser();
        BasicResult result = new BasicResult(callback, new Handler(Looper.getMainLooper()), null, 4, null);
        User user2 = user;
        if (user2 != null) {
            User user3 = user2;
            boolean bl2 = false;
            boolean bl3 = false;
            User it = user3;
            boolean bl4 = false;
            if (it.isOptedIn()) {
                List<FlybitsContextPlugin> flybitsContextPluginList = ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().getAll();
                Iterable $this$forEach$iv = flybitsContextPluginList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FlybitsContextPlugin pluginList = (FlybitsContextPlugin)element$iv;
                    boolean bl5 = false;
                    if (!pluginList.isRunning()) continue;
                    Logger.appendTag((String)"CtxManager").d("Refreshing Context Plugins " + pluginList.getContextPluginRetriever().getName());
                    pluginList.onRefresh(mContext);
                }
                bl = result.setSuccess();
            } else {
                bl = result.setFailed((FlybitsException)new UserOptedOutException("User has Opt out from Flybits"));
            }
        } else {
            bl = result.setFailed((FlybitsException)new NotConnectedException("No User has Connected to Flybits"));
        }
    }

    @JvmStatic
    public static final void start(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error starting the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, plugin, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;
            final /* synthetic */ FlybitsContextPlugin $plugin;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.startSync(this.$mContext, this.$plugin);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                this.$plugin = flybitsContextPlugin;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void startSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        UserDAO userDAO = CommonsDatabase.getDatabase((Context)mContext).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(mContext).userDao()");
        User user = userDAO.getActiveUser();
        if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginsWorker.class) {
            User user2 = user;
            if (user2 != null) {
                User user3 = user2;
                boolean bl = false;
                boolean bl2 = false;
                User it = user3;
                boolean bl3 = false;
                if (it.isOptedIn()) {
                    Logger.appendTag((String)"CtxManager").d("Starting Context Plugins using workers");
                    plugin.onStart(mContext);
                }
            }
            ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
        } else if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginService.class) {
            Intent intent = new Intent(mContext, plugin.getService());
            if (ContextUtilities.isServiceDefined(mContext, intent)) {
                User user4 = user;
                Intrinsics.checkExpressionValueIsNotNull((Object)user4, (String)"user");
                if (user4.isOptedIn()) {
                    Logger.appendTag((String)"CtxManager").d("Starting Context Plugins using services");
                    plugin.onStart(mContext);
                }
                ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
            } else {
                Displayer displayer = Logger.appendTag((String)"CtxManager");
                StringBuilder stringBuilder = new StringBuilder().append("Cannot start Context Plugin: In order to start the plugin you need to add the corresponding ");
                Class<? extends FlybitsContextPluginService> clazz = plugin.getService();
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                displayer.e(stringBuilder.append(clazz.getSimpleName()).append(" service in your manifest.").toString());
            }
        } else {
            Logger.appendTag((String)"CtxManager").w("This is unexpected since the FlybitsContextPlugin should either be of type FlybitsContextPluginService or FlybitsContextPluginsWorker");
        }
    }

    @JvmStatic
    public static final void resume(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error resuming the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, plugin, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;
            final /* synthetic */ FlybitsContextPlugin $plugin;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.resumeSync(this.$mContext, this.$plugin);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                this.$plugin = flybitsContextPlugin;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void resumeSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        block0: {
            User user;
            Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
            Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
            UserDAO userDAO = CommonsDatabase.getDatabase((Context)mContext).userDao();
            Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(mContext).userDao()");
            User user2 = user = userDAO.getActiveUser();
            if (user2 == null) break block0;
            User user3 = user2;
            boolean bl = false;
            boolean bl2 = false;
            User it = user3;
            boolean bl3 = false;
            ContextManager.resumeSync(mContext, plugin, it);
        }
    }

    @JvmStatic
    public static final void resumeSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginsWorker.class) {
            User user2 = user;
            if (user2 != null) {
                User user3 = user2;
                boolean bl = false;
                boolean bl2 = false;
                User it = user3;
                boolean bl3 = false;
                if (it.isOptedIn()) {
                    Logger.appendTag((String)"CtxManager").d("Resume Context Plugins using Workers.");
                    plugin.onStart(mContext);
                    ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().update(plugin);
                }
            }
        } else if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginService.class) {
            Intent intent = new Intent(mContext, plugin.getService());
            if (ContextUtilities.isServiceDefined(mContext, intent)) {
                User user4 = user;
                if (user4 != null) {
                    User user5 = user4;
                    boolean bl = false;
                    boolean bl4 = false;
                    User it = user5;
                    boolean bl5 = false;
                    if (it.isOptedIn()) {
                        Logger.appendTag((String)"CtxManager").d("Resume Context Plugins using Service.");
                        plugin.onStart(mContext);
                        ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().update(plugin);
                    }
                }
            } else {
                ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().delete(plugin);
                Displayer displayer = Logger.appendTag((String)"CtxManager");
                StringBuilder stringBuilder = new StringBuilder().append("Cannot start Context Plugin: In order to start the plugin you need to add the corresponding ");
                Class<? extends FlybitsContextPluginService> clazz = plugin.getService();
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                displayer.e(stringBuilder.append(clazz.getSimpleName()).append(" service in your manifest.").toString());
            }
        } else {
            Logger.appendTag((String)"CtxManager").w("This is unexpected since the FlybitsContextPlugin should either be of type FlybitsContextPluginService or FlybitsContextPluginsWorker");
        }
    }

    @JvmStatic
    public static final void stop(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error stopping the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, plugin, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;
            final /* synthetic */ FlybitsContextPlugin $plugin;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.stopSync(this.$mContext, this.$plugin);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                this.$plugin = flybitsContextPlugin;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void stopSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Logger.appendTag((String)"CtxManager").d("Stopping Context Plugins.");
        plugin.onStop(mContext);
        ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().delete(plugin);
    }

    @JvmStatic
    public static final void pause(@NotNull Context mContext, @NotNull FlybitsContextPlugin flybitsContextPlugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)flybitsContextPlugin, (String)"flybitsContextPlugin");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error pausing the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, flybitsContextPlugin, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;
            final /* synthetic */ FlybitsContextPlugin $flybitsContextPlugin;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.pauseSync(this.$mContext, this.$flybitsContextPlugin);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                this.$flybitsContextPlugin = flybitsContextPlugin;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void pauseSync(@NotNull Context mContext, @NotNull FlybitsContextPlugin flybitsContextPlugin) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)flybitsContextPlugin, (String)"flybitsContextPlugin");
        Logger.appendTag((String)"CtxManager").d("Pausing Context Plugins.");
        flybitsContextPlugin.onStop(mContext);
        ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().update(flybitsContextPlugin);
    }

    @JvmStatic
    public static final void pauseAll(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error pausing all the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.pauseAllSync(this.$mContext);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void pauseAllSync(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        List<FlybitsContextPlugin> flybitsContextPluginList = ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().getAll();
        Iterable $this$forEach$iv = flybitsContextPluginList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlybitsContextPlugin pluginList = (FlybitsContextPlugin)element$iv;
            boolean bl = false;
            ContextManager.pauseSync(mContext, pluginList);
        }
    }

    @JvmStatic
    public static final void resumeAll(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)INSTANCE.exceptionHandlerBuilder("Error resuming all the context plugins.")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mContext, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $mContext;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        ContextManager.resumeAllSync(this.$mContext);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$mContext = context;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void resumeAllSync(@NotNull Context mContext) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        UserDAO userDAO = CommonsDatabase.getDatabase((Context)mContext).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(mContext).userDao()");
        User user2 = user = userDAO.getActiveUser();
        if (user2 != null) {
            User user3 = user2;
            boolean bl = false;
            boolean bl2 = false;
            User it = user3;
            boolean bl3 = false;
            List<FlybitsContextPlugin> flybitsContextPluginList = ContextDatabase.Companion.getDatabase(mContext).flybitsContextPluginDAO().getAll();
            Iterable $this$forEach$iv = flybitsContextPluginList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FlybitsContextPlugin pluginList = (FlybitsContextPlugin)element$iv;
                boolean bl4 = false;
                ContextManager.resumeSync(mContext, pluginList, it);
            }
        }
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="This functionality will be removed from the SDK."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void registerForRules(@NotNull Context mContext, long timeInSeconds, long timeInSecondsFlex, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        PeriodicTask.Builder task = new PeriodicTask.Builder().setTag("Context_Rules").setUpdateCurrent(true).setPersisted(true).setPeriod(unit.toSeconds(timeInSeconds)).setService(ContextRulesService.class);
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.appendTag((String)"CtxManager").d("Activated: Context_Rules, Time to Refresh: " + timeInSeconds);
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="This functionality will be removed from the SDK."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void registerForPluginUpdates(@NotNull Context mContext, @NotNull HashMap<String, String> listOfClass, long timeToRefreshInSec) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull(listOfClass, (String)"listOfClass");
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(mContext).edit();
        preferences.putInt("ContextPlugin-size", listOfClass.size());
        preferences.putLong("ContextPlugin-refreshTime", timeToRefreshInSec);
        Bundle bundle = new Bundle();
        bundle.putInt("listOfItems", listOfClass.size());
        int i = 0;
        Map $this$forEach$iv = listOfClass;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)entry.getKey();
            entry = $dstr$k$v;
            bl3 = false;
            String v = (String)entry.getValue();
            bundle.putString("item" + i, k);
            preferences.putString("item" + i, k);
            bundle.putString("class" + i, v);
            bundle.putString("value" + i, v);
            listOfClass.remove(k);
            int n = i;
            i = n + 1;
        }
        preferences.apply();
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        OneoffTask oneTimeTask = new OneoffTask.Builder().setService(ContextPluginsService.class).setTag("Context_Plugin_Once").setExecutionWindow(0L, 30L).setRequiredNetwork(2).build();
        mGcmNetworkManager.schedule((Task)oneTimeTask);
        PeriodicTask.Builder task = new PeriodicTask.Builder().setExtras(bundle).setTag("Context_Plugin").setUpdateCurrent(true).setPersisted(true).setPeriod(timeToRefreshInSec).setService(ContextPluginsService.class);
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.appendTag((String)"CtxManager").d("Activated: Context_Plugin - Time to Refresh (in seconds): " + timeToRefreshInSec);
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="This functionality will be removed from the SDK."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void registerUploadingContext(@NotNull Context mContext, @NotNull ContextPriority priority, long time, long timeInSecondsFlex, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)priority), (String)"priority");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Bundle bundle = new Bundle();
        bundle.putInt("priority", priority.getKey());
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        PeriodicTask.Builder builder = new PeriodicTask.Builder();
        boolean bl = false;
        boolean bl2 = false;
        PeriodicTask.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setExtras(bundle).setTag("Context_Uploading").setUpdateCurrent(true).setPersisted(true).setRequiredNetwork(0).setPeriod(unit.toSeconds(time)).setService(ContextUploadingService.class);
        PeriodicTask.Builder task = builder;
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.appendTag((String)"CtxManager").d("Activated: Context_Uploading with Priority: " + priority.getKey() + ", Time to Refresh: " + time);
    }

    @JvmStatic
    public static final void registerUploadingContext(long time) {
        INSTANCE.scheduleWorker(time);
    }

    private final void scheduleWorker(long time) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026TED)\n            .build()");
        Constraints constraintsNetwork = constraints;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(ContextUploadingWorker.class, time, TimeUnit.MINUTES).setConstraints(constraintsNetwork)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"PeriodicWorkRequest\n    \u2026ork)\n            .build()");
        PeriodicWorkRequest workRequest2 = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance().enqueueUniquePeriodicWork(ContextUploadingWorker.class.getSimpleName(), ExistingPeriodicWorkPolicy.REPLACE, workRequest2);
        Logger.appendTag((String)"CtxManager").d("Activated: Context_Uploading , Time to Refresh: " + time);
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="This functionality will be removed from the SDK."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void unregisterFromRuleCollection(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intent intent = new Intent(mContext, ContextRulesService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Rules", ContextRulesService.class);
                Logger.appendTag((String)"CtxManager").d("UnActivated: Context_Rules");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterFromRuleCollection", (Exception)ex);
            }
        }
        Logger.appendTag((String)"CtxManager").d("Unregistered service for retrieving rules.");
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="Since [GcmNetworkManager] API deprecated, instead using [WorkManager] API."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void unregisterUploadingContext(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intent intent = new Intent(mContext, ContextUploadingService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Uploading", ContextUploadingService.class);
                Logger.appendTag((String)"CtxManager").d("UnActivated: Context_Uploading");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterUploadingContext", (Exception)ex);
            }
        }
        Logger.appendTag((String)"CtxManager").d("Unregistered service for UploadingContext.");
    }

    @JvmStatic
    public static final void unregisterUploadingContext() {
        WorkManager.getInstance().cancelUniqueWork(ContextUploadingWorker.class.getSimpleName());
        Logger.appendTag((String)"CtxManager").d("ContextManager.unregisterPluginContext Completed");
    }

    @Deprecated(message="Deprecated in version 2.3.0, will be removed in version 4.0.0", replaceWith=@ReplaceWith(imports={}, expression="Since [GcmNetworkManager] API deprecated, instead using [WorkManager] API."), level=DeprecationLevel.WARNING)
    @JvmStatic
    public static final void unregisterPluginContext(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intent intent = new Intent(mContext, ContextPluginsService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Plugin", ContextPluginsService.class);
                Logger.appendTag((String)"CtxManager").d("UnActivated: Context_Plugin");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterPluginContext", (Exception)ex);
            }
        }
        Logger.appendTag((String)"CtxManager").d("Unregistered service for uploading Context Plugins.");
    }

    @JvmStatic
    private static final <T extends ContextData> ObjectResult<T> getDataPrivate(Context context, String pluginID, Class<T> subclass, ObjectResultCallback<T> callback) {
        ExecutorService executorService;
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService2 = executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService2, (String)"executorService");
        ObjectResult objectResult = new ObjectResult(callback, handler, executorService2);
        executorService.execute(new Runnable(context, pluginID, subclass, objectResult){
            final /* synthetic */ Context $context;
            final /* synthetic */ String $pluginID;
            final /* synthetic */ Class $subclass;
            final /* synthetic */ ObjectResult $objectResult;

            public final void run() {
                BasicData dataFromCursor = ContextDatabase.Companion.getDatabase(this.$context).basicDataDao().get(this.$pluginID);
                if (dataFromCursor != null && dataFromCursor.getValueAsString() != null) {
                    try {
                        T t = this.$subclass.newInstance();
                        if (t == null) {
                            throw new TypeCastException("null cannot be cast to non-null type T");
                        }
                        ContextData data = (ContextData)t;
                        data.fromJson(dataFromCursor.getValueAsString());
                        data.setTime(dataFromCursor.getTimestamp());
                        Result result = new Result(200, "");
                        result.setResponse((Object)data);
                        this.$objectResult.setResult(result);
                    }
                    catch (Exception e) {
                        this.$objectResult.setResult(new Result(new FlybitsException(e.getMessage()), ""));
                        Logger.e((String)"Exception on ContextManager.getData");
                    }
                }
            }
            {
                this.$context = context;
                this.$pluginID = string;
                this.$subclass = clazz;
                this.$objectResult = objectResult;
            }
        });
        return objectResult;
    }

    private ContextManager() {
    }

    static {
        ContextManager contextManager;
        INSTANCE = contextManager = new ContextManager();
        job = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)job));
    }

    public static final /* synthetic */ void access$refreshAllSync(Context mContext, BasicResultCallback callback) {
        ContextManager.refreshAllSync(mContext, callback);
    }
}

