/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.services;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.flybits.commons.library.exceptions.PermissionNotSetException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.ContextScope;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.FlybitsContextPlugin;
import com.flybits.context.utils.ContextUtilities;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.TaskParams;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class FlybitsContextPluginService
extends GcmTaskService {
    private static final String TAG_CONTEXT_PLUGIN = "ContextPluginService";
    private ScheduledExecutorService scheduleTaskExecutor;
    private long refreshTime;
    public static final String PREF_CP_REFRESH_RATE_START = "ContextPlugin-";

    public void onCreate() {
        super.onCreate();
        Logger.appendTag((String)TAG_CONTEXT_PLUGIN).d(((Object)((Object)this)).getClass().getCanonicalName() + " : " + ((Object)((Object)this)).getClass().getSimpleName());
        if (!this.isSupported()) {
            this.stopSelf();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.initialize(intent.getExtras());
        this.refreshTime = intent.getLongExtra("flybits_minimum_refresh_time", 60L);
        if (this.refreshTime < 60L) {
            this.startForeground(((Object)((Object)this)).hashCode(), (Notification)intent.getParcelableExtra("flybits_extra_notification"));
            long timeToRefresh = this.refreshTime < 10L ? 10L : this.refreshTime;
            this.refreshContextData(timeToRefresh);
            return 3;
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        if (this.scheduleTaskExecutor != null && !this.scheduleTaskExecutor.isShutdown()) {
            this.scheduleTaskExecutor.shutdownNow();
        }
        super.onDestroy();
    }

    public int onRunTask(TaskParams taskParams) {
        Logger.appendTag((String)TAG_CONTEXT_PLUGIN).d("onRunTask: " + ((Object)((Object)this)).getClass().getSimpleName());
        if (this.checkPermissions(this.getBaseContext())) {
            this.initialize(taskParams.getExtras());
            ContextData data = this.getData();
            if (data != null) {
                long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
                data.update(this.getBaseContext(), timeInSec);
            }
            this.wait(2L, TimeUnit.SECONDS);
        }
        return 0;
    }

    public Context getContext() {
        return this.getBaseContext();
    }

    public void onInitializeTasks() {
        Logger.appendTag((String)TAG_CONTEXT_PLUGIN).d("onInitializeTask: " + ((Object)((Object)this)).getClass().getSimpleName());
        SharedPreferences preferences = ContextScope.getContextPreferences(this.getBaseContext());
        long refreshTime = preferences.getLong(FlybitsContextPlugin.Companion.getPrefName(((Object)((Object)this)).getClass()), 3600L);
        if (refreshTime == 3600L) {
            refreshTime = preferences.getLong(((Object)((Object)this)).getClass().getCanonicalName(), 3600L);
        }
        Bundle bundle = new Bundle();
        bundle.putLong("flybits_minimum_refresh_time", refreshTime);
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)this.getBaseContext());
        PeriodicTask.Builder task = new PeriodicTask.Builder().setTag(((Object)((Object)this)).getClass().getSimpleName()).setExtras(bundle).setPersisted(true).setUpdateCurrent(true).setService(((Object)((Object)this)).getClass()).setPeriod(refreshTime);
        mGcmNetworkManager.schedule((Task)task.build());
    }

    public abstract ContextData getData();

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public abstract String[] getRequiredPermissions();

    public abstract void initialize(Bundle var1);

    public abstract boolean isSupported();

    public void wait(long time, TimeUnit unit) {
        long mServiceStartTime = System.currentTimeMillis();
        long waitInMilli = unit.toMillis(time);
        while (System.currentTimeMillis() - mServiceStartTime <= waitInMilli) {
            Thread.yield();
        }
    }

    private boolean checkPermissions(Context context) throws PermissionNotSetException {
        String[] listOfPermissions;
        for (String permission2 : listOfPermissions = this.getRequiredPermissions()) {
            if (ContextUtilities.isPermissionGranted(context, permission2)) continue;
            Log.e((String)"Flybits", (String)("You are attempting to register to this context plugin without enabling the " + permission2 + " permission. This is not possible. Please include this permission in your manifest. "));
            return false;
        }
        return true;
    }

    private void refreshContextData(long timeToRefresh) {
        this.scheduleTaskExecutor = Executors.newScheduledThreadPool(1);
        this.scheduleTaskExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                new SeparateThread().start();
            }
        }, 0L, timeToRefresh, TimeUnit.SECONDS);
    }

    private class SeparateThread
    extends Thread {
        SeparateThread() {
        }

        @Override
        public void run() {
            ContextData data = FlybitsContextPluginService.this.getData();
            if (data != null) {
                long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
                data.update(FlybitsContextPluginService.this.getBaseContext(), timeInSec);
            }
        }
    }
}

