/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.os.Parcelable;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextScope;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.deserializations.DeserializeEvaluatedRules;
import com.flybits.context.models.RuleEvalutated;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ContextRulesService
extends GcmTaskService {
    public static final String PREF_RULES_REFRESH_TIME = "updateRate-ContextRules";
    private static final String TAG_CONTEXT_RULES = "ContextRulesService";

    public void onInitializeTasks() {
        super.onInitializeTasks();
        SharedPreferences preferences = ContextScope.getContextPreferences(this.getBaseContext());
        long numberOfSeconds = preferences.getLong(PREF_RULES_REFRESH_TIME, 3600L);
        ContextManager.registerForRules(this.getBaseContext(), numberOfSeconds, numberOfSeconds, TimeUnit.SECONDS);
    }

    public int onRunTask(TaskParams taskParams) {
        Logger.appendTag((String)TAG_CONTEXT_RULES).d("Starting Context Rules Retrieval...");
        return this.getRules() ? 0 : 2;
    }

    boolean getRules() {
        try {
            QueryBuilder builder = new QueryBuilder();
            Result result = FlyAway.get((Context)this.getBaseContext(), (String)"/context/rules/evaluations", (QueryParameters)new QueryParameters(builder), (IDeserializer)new DeserializeEvaluatedRules(), (String)"ContextRulesService.getRules");
            if (result != null && result.getResult() != null && result.getStatus() == RequestStatus.COMPLETED) {
                List<RuleEvalutated> listOfOldRules = ContextDatabase.getDatabase(this.getBaseContext()).ruleDao().getAll();
                this.deleteRules(this.getBaseContext(), listOfOldRules, ((PagedResponse)result.getResult()).getItems());
                for (RuleEvalutated rule : ((PagedResponse)result.getResult()).getItems()) {
                    int index = listOfOldRules.indexOf(rule);
                    if (index != -1) {
                        RuleEvalutated oldRuleSaved = listOfOldRules.get(index);
                        this.updateOldRule(this.getBaseContext(), oldRuleSaved, rule);
                        continue;
                    }
                    Logger.appendTag((String)TAG_CONTEXT_RULES).d("New Rule: " + rule.getId());
                    this.insertNewRule(this.getBaseContext(), rule);
                }
                return true;
            }
        }
        catch (SQLException | FlybitsException e) {
            Logger.exception((String)"ContextRulesService.onRunTask_II", (Exception)e);
        }
        return false;
    }

    public void deleteRules(Context context, List<RuleEvalutated> listOfOldRules, ArrayList<RuleEvalutated> listOfNewRules) {
        if (listOfNewRules == null || listOfOldRules == null) {
            return;
        }
        for (RuleEvalutated oldRule : listOfOldRules) {
            int index = listOfNewRules.indexOf(oldRule);
            if (index != -1) continue;
            ContextDatabase.getDatabase(context).ruleDao().delete(oldRule);
            Logger.appendTag((String)TAG_CONTEXT_RULES).d("Deleted old Rule: " + oldRule.getId());
        }
    }

    public void updateOldRule(Context context, RuleEvalutated rule, RuleEvalutated oldRuleSaved) {
        if (oldRuleSaved.isLastResult() != rule.isLastResult()) {
            Intent broadcastRuleStatusUpdated = new Intent("com.flybits.broadcasts.rule.status.UPDATED");
            broadcastRuleStatusUpdated.putExtra("com.flybits.broadcasts.extras.RULE", (Parcelable)rule);
            context.sendBroadcast(broadcastRuleStatusUpdated);
            ContextDatabase.getDatabase(context).ruleDao().update(rule);
            Logger.appendTag((String)TAG_CONTEXT_RULES).d("DATA UPDATED Amount: " + rule.getId());
        }
    }

    public void insertNewRule(Context context, RuleEvalutated rule) {
        try {
            ContextDatabase.getDatabase(context).ruleDao().insert(rule);
            Logger.appendTag((String)TAG_CONTEXT_RULES).d("DATA INSERTED Amount: " + rule.getId());
            Intent broadcastRuleStatusUpdated = new Intent("com.flybits.broadcasts.rule.status.UPDATED");
            broadcastRuleStatusUpdated.putExtra("com.flybits.broadcasts.extras.RULE", (Parcelable)rule);
            context.sendBroadcast(broadcastRuleStatusUpdated);
        }
        catch (IllegalStateException exception) {
            Logger.exception((String)"ContextRulesService.insertNewRule", (Exception)exception);
        }
    }

    public void onDestroy() {
        Logger.appendTag((String)TAG_CONTEXT_RULES).d("Destroyed Context Rules Retrieval");
        super.onDestroy();
    }
}

