/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextPluginsService;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.ContextPriority;
import com.flybits.context.models.internal.Plugin;
import com.flybits.context.services.FlybitsContextPluginService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ContextScope
extends FlybitsScope {
    public static final String ROOT = "/context";
    private String TAG = "ContextScope";
    private long timeToUploadContext;
    private long timeToRetrieveRules;
    private long timeToRetrieveContextPlugins;
    private boolean autoStartContextCollection;
    private HashMap<String, String> classesAsString;
    public static ContextScope SCOPE = new ContextScope();

    ContextScope() {
        super("ContextSDK");
    }

    public ContextScope(long timeToUploadContext, @NonNull TimeUnit unit) {
        this(timeToUploadContext, -1L, unit, -1L, false, null);
    }

    @Deprecated
    public ContextScope(long timeToUploadContext, @NonNull TimeUnit unit, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        this(timeToUploadContext, -1L, unit, -1L, true, classes);
    }

    public ContextScope(long timeToUploadContext, long timeToRetrieveContextPlugins, @NonNull TimeUnit unit, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        this(timeToUploadContext, -1L, unit, timeToRetrieveContextPlugins, true, classes);
    }

    private ContextScope(long timeToUploadContext, long timeToRetrieveRules, @NonNull TimeUnit unit, long timeToRetrieveContextPlugins, boolean autoStartContextCollection, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        super("CONTEXT_SDK");
        this.autoStartContextCollection = autoStartContextCollection;
        this.classesAsString = new HashMap();
        if (timeToUploadContext != -1L) {
            this.timeToUploadContext = unit.toMinutes(timeToUploadContext);
            if (this.timeToUploadContext == 0L) {
                this.timeToUploadContext = 1L;
            }
        } else {
            this.timeToUploadContext = -1L;
        }
        if (timeToRetrieveRules != -1L) {
            this.timeToRetrieveRules = unit.toMinutes(timeToRetrieveRules);
            if (this.timeToRetrieveRules == 0L) {
                this.timeToRetrieveRules = 1L;
            }
        } else {
            this.timeToRetrieveRules = -1L;
        }
        if (timeToRetrieveContextPlugins != -1L) {
            this.timeToRetrieveContextPlugins = unit.toSeconds(timeToRetrieveContextPlugins);
            if (this.timeToRetrieveContextPlugins == 0L) {
                this.timeToRetrieveContextPlugins = 86400L;
            }
        } else {
            this.timeToRetrieveContextPlugins = 86400L;
        }
        if (autoStartContextCollection && classes != null && classes.size() > 0) {
            Iterator<Map.Entry<String, Class<? extends FlybitsContextPluginService>>> it = classes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Class<? extends FlybitsContextPluginService>> pair = it.next();
                this.classesAsString.put(pair.getKey(), pair.getValue().getCanonicalName());
                it.remove();
            }
        }
    }

    long getTimeToUploadContext() {
        return this.timeToUploadContext;
    }

    long getTimeToRetrieveRules() {
        return this.timeToRetrieveRules;
    }

    boolean isAutoStartContextCollection() {
        return this.autoStartContextCollection;
    }

    public void onConnected(Context context, User user) {
        Logger.appendTag((String)this.TAG).d("onConnected: " + user);
        ContextDatabase.getDatabase(context).basicDataDao().deleteAll();
        if (user != null && user.isOptedIn()) {
            this.setup(context);
        }
    }

    public void onDisconnected(Context context, String jwtToken) {
        Logger.appendTag((String)this.TAG).d("onDisconnected");
        this.cleanAll(context);
    }

    public void onAccountDestroyed(Context context, String jwtToken) {
        Logger.appendTag((String)this.TAG).d("onAccountDestroyed");
        this.cleanAll(context);
    }

    public void onOptedStateChange(Context context, boolean optedState) {
        Logger.appendTag((String)this.TAG).d("onOptedStateChange: " + optedState);
        if (!optedState) {
            this.cleanForOptOut(context);
            ContextManager.pauseAll(context);
        } else {
            this.setup(context);
        }
    }

    void setup(Context context) {
        SharedPreferences.Editor preferences;
        if (this.timeToUploadContext > 0L) {
            preferences = ContextScope.getContextPreferences(context).edit();
            preferences.putLong("updateRate-ContextUpload", TimeUnit.MINUTES.toSeconds(this.timeToUploadContext));
            preferences.apply();
            ContextManager.registerUploadingContext(context, ContextPriority.HIGH, this.timeToUploadContext, 1L, TimeUnit.MINUTES);
        }
        if (this.timeToRetrieveRules > 0L) {
            preferences = ContextScope.getContextPreferences(context).edit();
            preferences.putLong("updateRate-ContextRules", TimeUnit.MINUTES.toSeconds(this.timeToRetrieveRules));
            preferences.apply();
            ContextManager.registerForRules(context, this.timeToRetrieveRules, 1L, TimeUnit.MINUTES);
        }
        if (this.autoStartContextCollection) {
            ContextManager.registerForPluginUpdates(context, this.classesAsString, this.timeToRetrieveContextPlugins);
        }
        ContextManager.resumeAll(context);
    }

    void cleanForOptOut(Context context) {
        ContextManager.unregisterUploadingContext(context);
        ContextManager.unregisterFromRuleCollection(context);
        ContextManager.unregisterPluginContext(context);
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(context).edit();
        preferences.clear();
        preferences.apply();
        ContextDatabase contextDatabase = ContextDatabase.getDatabase(context);
        contextDatabase.pluginDao().deleteAll();
        contextDatabase.basicDataDao().deleteAll();
        contextDatabase.beaconActiveDao().deleteAll();
        contextDatabase.beaconMonitoredDao().deleteAll();
        contextDatabase.ruleDao().deleteAll();
    }

    void cleanAll(Context context) {
        ContextDatabase contextDatabase = ContextDatabase.getDatabase(context);
        List<Plugin> listOfOldPlugins = contextDatabase.pluginDao().getAll();
        for (Plugin plugin : listOfOldPlugins) {
            ContextPluginsService.stopContextPlugin(context, this.classesAsString, plugin);
        }
        ContextManager.pauseAll(context);
        this.cleanForOptOut(context);
    }

    public static SharedPreferences getContextPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_CONTEXT", 0);
    }
}

