package com.flybits.context.plugins.beacon;

import android.app.Notification;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextScope;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.deserializations.DeserializeMonitoredBeacons;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;
import org.altbeacon.beacon.*;
import org.altbeacon.beacon.powersave.BackgroundPowerSaver;
import org.altbeacon.beacon.startup.BootstrapNotifier;
import org.altbeacon.beacon.startup.RegionBootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import static com.flybits.context.plugins.FlybitsContextPlugin.EXTRA_NOTIFICATION;

/**
 * @deprecated {@link BeaconScanningService} will be updated in later releases. Avoid using this plugin.
 */
@Deprecated
public class BeaconScanningService extends FlybitsContextPluginService implements BootstrapNotifier, RangeNotifier {

    static final String API_CONTEXT_BEACONS_GETTOMONITOR    = ContextScope.ROOT+"/beacons/monitoring";
    private final long SCAN_PERIOD      = 10000;
    private final String TAG_BEACON_SERVICE = "BeaconScanningService";
    private final String FRAME_IBEACON  = "m:0-3=4c000215,i:4-19,i:20-21,i:22-23,p:24-24";

    private BackgroundPowerSaver backgroundPowerSaver;
    private RegionBootstrap regionBootstrap;
    private BeaconManager mBeaconManager;

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        initialize(intent.getExtras());
        Notification notification = intent.getParcelableExtra(EXTRA_NOTIFICATION);
        startForeground(1,notification);
        return START_REDELIVER_INTENT;
    }

    @Override
    public void initialize(Bundle bundle) {
        setupBeaconMetadata();
    }

    private void setupBeaconMetadata() {
        //(i)      Beacon Setup including the amount of time between scans.
        mBeaconManager = BeaconManager.getInstanceForApplication(this);
        mBeaconManager.getBeaconParsers().add(new BeaconParser().
                setBeaconLayout(BeaconParser.EDDYSTONE_UID_LAYOUT));
        mBeaconManager.getBeaconParsers().add(new BeaconParser().
                setBeaconLayout(BeaconParser.EDDYSTONE_TLM_LAYOUT));
        mBeaconManager.getBeaconParsers().add(new BeaconParser().
                setBeaconLayout(BeaconParser.EDDYSTONE_URL_LAYOUT));
        mBeaconManager.getBeaconParsers().add(new BeaconParser().
                setBeaconLayout(FRAME_IBEACON));
        mBeaconManager.getBeaconParsers().add(new BeaconParser().
                setBeaconLayout(BeaconParser.ALTBEACON_LAYOUT));

        new GetMonitoredBeacons().execute();
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        if (regionBootstrap != null) {
            regionBootstrap.disable();
        }
        super.onDestroy();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        return null;
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }

//    @Override
    public void onBeaconServiceConnect() {}

    @Override
    public void didEnterRegion(Region region) {
        Logger.appendTag(TAG_BEACON_SERVICE).d( "Did Enter Region: " + region);
        try {
            mBeaconManager.startRangingBeaconsInRegion(region);
            Logger.appendTag(TAG_BEACON_SERVICE).d("StartRanging");
        } catch (RemoteException e) {
            Logger.exception("BeaconScanningService.didEnterRegion", e);
        }
    }

    @Override
    public void didExitRegion(final Region region) {
        Logger.appendTag(TAG_BEACON_SERVICE).d("Did Exit Region: " + region);
        new AsyncTask<Void, Void, List<BeaconActive>>() {

            protected List<BeaconActive> doInBackground(Void... unused) {
                List<BeaconActive> listOfBeacons = ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().getAll();
                return listOfBeacons;
            }

            protected void onPostExecute(List<BeaconActive> listOfBeacons) {
                if (listOfBeacons != null && listOfBeacons.size() == 0) {
                    try {
                        mBeaconManager.stopRangingBeaconsInRegion(region);
                    } catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.execute();
    }

    @Override
    public void didDetermineStateForRegion(int i, Region region) {}

    @Override
    public void didRangeBeaconsInRegion(final Collection<Beacon> beacons, final Region region) {
        Logger.appendTag(TAG_BEACON_SERVICE).d("Did Range Beacons In Region:" + beacons.size());
        new AsyncTask<Void, Void, List<BeaconActive>>() {

            protected List<BeaconActive> doInBackground(Void... unused) {
                List<BeaconActive> listOfBeacons = ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().getAll();
                Logger.appendTag(TAG_BEACON_SERVICE).d("Number of Total Rows: " + listOfBeacons.size());

                List<BeaconActive> listOfBeaconsNotInRange = ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().getAllNotInRange();
                Logger.appendTag(TAG_BEACON_SERVICE).d("Number of Rows To Delete: " + listOfBeaconsNotInRange.size());
                if (listOfBeaconsNotInRange.size() > 0){

                    long currentTime = System.currentTimeMillis() / 1000;
                    for (BeaconActive active : listOfBeacons){

                        if (currentTime - active.getLastSeen() > 30){
                            active.setInRange(false);
                            ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().update(active);
                            Logger.appendTag(TAG_BEACON_SERVICE).d("Set To False: " + active.getCompositeID());
                        }
                    }
                }

                for (Beacon beacon : beacons) {
                    Logger.appendTag(TAG_BEACON_SERVICE).d("The beacon " + beacon.toString() + " is about " + beacon.getDistance() + " meters away.");
                    String compositeID = beacon.getId1().toString();

                    if (beacon.getId2() != null){
                        compositeID += ("_" + beacon.getId2().toString());
                    }

                    if (beacon.getId3() != null){
                        compositeID += ("_" + beacon.getId3().toString());
                    }

                    BeaconActive beaconWithCompositeID = ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().get(compositeID);
                    if (beaconWithCompositeID != null){
                        Logger.appendTag(TAG_BEACON_SERVICE).d( "This beacon has been previously saved");
                        beaconWithCompositeID.setInRange(true);
                        beaconWithCompositeID.setTimestamp(System.currentTimeMillis() / 1000);
                        ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().update(beaconWithCompositeID);
                    }else{
                        Logger.appendTag(TAG_BEACON_SERVICE).d("This beacon has NOT been previously saved");
                        BeaconActive activeBeacon = new BeaconActive(beacon);
                        activeBeacon.setInRange(true);
                        ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().insert(activeBeacon);
                    }
                }

                return ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().getAll();
            }

            protected void onPostExecute(List<BeaconActive> listOfBeacons) {
                if (listOfBeacons.size() == 0){
                    try {
                        mBeaconManager.stopRangingBeaconsInRegion(region);
                    } catch (RemoteException e) {
                        Logger.exception("BeaconScanningService.didRangeBeaconsInRegion", e);
                    }
                }else {
                    new UploadBeaconData(listOfBeacons).execute();
                }
            }
        }.execute();
    }

    public class UploadBeaconData extends AsyncTask<Void, Integer, Void> {

        private BeaconDataList listOfActiveBeacons;

        public UploadBeaconData(List<BeaconActive> beacons){
            listOfActiveBeacons         = new BeaconDataList(beacons);
        }

        protected Void doInBackground(Void... args) {

            listOfActiveBeacons.updateNow(getBaseContext(), null);

            boolean isSuccessful =  ContextManager.flushContextData(getBaseContext());
            if (isSuccessful){

                ContextDatabase.getDatabase(getBaseContext()).beaconActiveDao().deleteBeaconsNotInRange();
                Logger.appendTag(TAG_BEACON_SERVICE).d("Deleted out of Range Beacons");
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute(result);
        }
    }

    public class GetMonitoredBeacons extends AsyncTask<Void, Integer, List<Region>> {

        protected List<Region> doInBackground(Void... args) {
            try {

                List<BeaconMonitored> listOfMonitored = ContextDatabase.getDatabase(getBaseContext()).beaconMonitoredDao().getAll();
                for (BeaconMonitored beacon : listOfMonitored) {

                    ContextDatabase.getDatabase(getBaseContext()).beaconMonitoredDao().delete(beacon);

                    try {

                        if (beacon.getType() == BeaconType.IBeacon) {
                            UUID uuid = UUID.fromString(beacon.getIdentifier());
                            mBeaconManager.stopRangingBeaconsInRegion(new Region(beacon.getIdentifier(), Identifier.fromUuid(uuid), null, null));
                        } else if (beacon.getType() == BeaconType.Eddystone) {
                            mBeaconManager.stopRangingBeaconsInRegion(new Region(beacon.getIdentifier(), Identifier.fromInt(Integer.parseInt(beacon.getIdentifier())), null, null));
                        }

                    } catch (IllegalArgumentException | RemoteException e) {
                        Logger.exception("BeaconScanningService.GetMonitoredBeacons.onPostExecute_I", e);
                    }

                }

                List<Region> listOfMonitoredRegions = new ArrayList<>();
                Result<PagedResponse<BeaconMonitored>> result = FlyAway.get(getBaseContext(), API_CONTEXT_BEACONS_GETTOMONITOR,
                        new QueryParameters(new QueryBuilder()), new DeserializeMonitoredBeacons(), "BeaconScanningService.GetMonitoredBeacons");

                if (result != null && result.getResult() != null && result.getResult().getItems() != null){
                    for (BeaconMonitored mb : result.getResult().getItems()) {
                        try {
                            Region region = null;
                            if (mb.getType() == BeaconType.IBeacon) {

                                UUID uuid = UUID.fromString(mb.getIdentifier());
                                region = new Region(mb.getIdentifier(), Identifier.fromUuid(uuid), null, null);
                                ContextDatabase.getDatabase(getBaseContext()).beaconMonitoredDao().insert(mb);

                            } else if (mb.getType() == BeaconType.Eddystone) {
                                region = new Region(mb.getIdentifier(), Identifier.fromInt(Integer.parseInt(mb.getIdentifier())), null, null);
                            }
                            if (region != null) {
                                listOfMonitoredRegions.add(region);
                            }
                        } catch (IllegalArgumentException e) {
                            Logger.exception("BeaconScanningService.GetMonitoredBeacons.onPostExecute_II", e);
                        }
                    }
                }
                return listOfMonitoredRegions;
            }catch (FlybitsException | IllegalStateException e){
                Logger.exception("BeaconScanningService.GetMonitoredBeacons.onPostExecute_III", e);}
            return null;
        }

        protected void onPostExecute(List<Region> result) {
            super.onPostExecute(result);

            if (result != null && result.size() > 0) {
                mBeaconManager.setBackgroundBetweenScanPeriod(SCAN_PERIOD);
                mBeaconManager.addRangeNotifier(BeaconScanningService.this);
                regionBootstrap         = new RegionBootstrap(BeaconScanningService.this, result);
                backgroundPowerSaver    = new BackgroundPowerSaver(BeaconScanningService.this);
            }else{
                stopSelf();
            }
        }
    }
}
