package com.flybits.context.plugins.battery

import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import androidx.work.WorkerParameters
import com.flybits.commons.library.logging.Logger
import com.flybits.context.models.ContextData
import com.flybits.context.services.FlybitsContextPluginsWorker

const val TAG = "PluginBattery"

/**
 * The [BatteryContextPluginWorker] is a worker responsible for retrieving the Battery Information.
 * This will be triggered by `WorkManager` on start of battery plugin to fetch the battery level and status after specified interval.
 * The minimum interval for the worker to execute is 900 seconds.
 */
class BatteryContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {

    override fun getData(): ContextData {
        Logger.appendTag(TAG).d("Fetching Battery Data...")
        return BatteryData(applicationContext, IntentFilter(Intent.ACTION_BATTERY_CHANGED))
    }

    override fun getRequiredPermissions(): Array<String> {
        return arrayOf()
    }

    override fun initialize(bundle: Bundle?) {}

    override fun isSupported(): Boolean {
        return true
    }
}