/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.location;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.location.LocationData;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.ExecutionException;

public class LocationContextPluginService
extends FlybitsContextPluginService {
    private static final String TAG_LOCATION_PLUGIN = "PluginLocation";
    private FusedLocationProviderClient fusedLocationProviderClient;
    private long minDisplacement = -1L;

    @Override
    public void initialize(Bundle bundle) {
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.getApplicationContext());
        if (bundle != null && bundle.containsKey("minDisplacement")) {
            this.minDisplacement = bundle.getLong("minDisplacement");
        }
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)this.getBaseContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    @Override
    public ContextData getData() {
        Logger.appendTag((String)TAG_LOCATION_PLUGIN).d("Fetching Data ...");
        try {
            if (this.isSupported()) {
                Location lastLocation = (Location)Tasks.await((Task)this.fusedLocationProviderClient.getLastLocation());
                return new LocationData(lastLocation);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.appendTag((String)TAG_LOCATION_PLUGIN).e("Exception : " + e.getMessage());
            return null;
        }
    }

    @Override
    public void onDestroy() {
        Logger.appendTag((String)TAG_LOCATION_PLUGIN).d("...Destroyed");
        super.onDestroy();
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    }
}

