/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.utils;

import androidx.annotation.NonNull;
import com.flybits.context.models.RulePredicate;
import com.flybits.context.models.RulePredicateQuery;
import com.flybits.context.utils.RuleScheduler;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class RuleBuilder {
    private String name;
    private String description;
    private boolean defaultEvaluated;
    private String color;
    private String scope;
    private String stringRepresentation;
    private static final String HEX_PATTERN_NAME = "[^A-Za-z0-9]";
    private HashMap<String, String> mapOfPredicateData;
    private RuleScheduler scheduler;

    private RuleBuilder(Builder builder) {
        this.name = builder.name;
        this.defaultEvaluated = builder.defaultEvaluated;
        this.color = builder.color;
        this.scope = builder.scope;
        this.stringRepresentation = builder.stringRepresentation;
        this.mapOfPredicateData = builder.mapOfPredicateData;
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.color != null) {
            this.color = builder.color;
        }
        if (builder.scheduler != null) {
            this.scheduler = builder.scheduler;
        }
    }

    public String getRequestBody() {
        JSONObject object = new JSONObject();
        try {
            object.put("name", (Object)this.name);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("defaultEvaluated", this.defaultEvaluated);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("scope", (Object)this.scope);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            String ruleRepresentation = this.convertNameToProperStructure(this.name) + "() :- " + this.stringRepresentation;
            object.put("stringRepresentation", (Object)ruleRepresentation);
        }
        catch (JSONException ruleRepresentation) {
            // empty catch block
        }
        try {
            if (this.description != null) {
                object.put("description", (Object)this.description);
            }
        }
        catch (JSONException ruleRepresentation) {
            // empty catch block
        }
        try {
            if (this.color != null) {
                object.put("color", (Object)this.color);
            }
        }
        catch (JSONException ruleRepresentation) {
            // empty catch block
        }
        try {
            if (this.scheduler != null) {
                object.put("schedule", (Object)this.scheduler.toJSONObject());
            }
        }
        catch (JSONException ruleRepresentation) {
            // empty catch block
        }
        try {
            if (this.mapOfPredicateData != null && this.mapOfPredicateData.size() > 0) {
                JSONObject mapPredicateData = new JSONObject();
                Iterator<Map.Entry<String, String>> it = this.mapOfPredicateData.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> pair = it.next();
                    mapPredicateData.put(pair.getKey(), (Object)pair.getValue());
                    it.remove();
                }
                object.put("pluginData", (Object)mapPredicateData);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    private String convertNameToProperStructure(String nameAsString) {
        return nameAsString.replaceAll(HEX_PATTERN_NAME, "-");
    }

    public static class Builder {
        private String name;
        private String description;
        private boolean defaultEvaluated = false;
        private String color;
        private String scope = "user";
        private String stringRepresentation;
        private Pattern patternColor = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
        private HashMap<String, String> mapOfPredicateData;
        private RuleScheduler scheduler;
        private static final String HEX_PATTERN_COLOR = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";

        private Builder() {
        }

        public Builder(@NonNull String name, @NonNull RulePredicateQuery predicateQuery) {
            this();
            this.name = name;
            this.stringRepresentation = predicateQuery.getQuery();
            this.mapOfPredicateData = predicateQuery.getMapOfRulePredicate();
        }

        public Builder(@NonNull String name, @NonNull RulePredicate predicate) {
            this();
            this.name = name;
            this.stringRepresentation = "(" + predicate.getString() + ")";
            this.mapOfPredicateData = predicate.getPluginData();
        }

        public RuleBuilder build() {
            return new RuleBuilder(this);
        }

        public Builder setColor(String hex) throws InvalidParameterException {
            Matcher matcher = this.patternColor.matcher(hex);
            if (!matcher.matches()) {
                throw new InvalidParameterException("The color parameter must be in either of the following formats #XXXXXX or #XXX where X is Hex value");
            }
            this.color = hex;
            return this;
        }

        public Builder setDefaultEvaluationAsTrue() {
            this.defaultEvaluated = true;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setScheduler(RuleScheduler scheduler) {
            if (scheduler != null) {
                this.scheduler = scheduler;
            }
            return this;
        }
    }
}

