/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.flybits.context.models.BasicData;
import com.flybits.context.models.ContextData;
import java.util.List;

public class ContextUtilities {
    public static void broadcastContextUpdate(Context mContext, ContextData data, String pluginID, long timeOccurred) {
        Intent contextData = new Intent("com.flybits.broadcasts.context.status.UPDATED");
        contextData.putExtra("com.flybits.broadcasts.context.extras.PLUGIN", pluginID);
        contextData.putExtra("com.flybits.broadcasts.context.extras.TIME", timeOccurred);
        contextData.putExtra("com.flybits.broadcasts.context.extras.DATA", (Parcelable)data);
        mContext.sendBroadcast(contextData);
        contextData.setAction(pluginID);
        mContext.sendBroadcast(contextData);
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permission2) {
        if (context == null || permission2 == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT > 22 && ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) {
            return true;
        }
        return ContextUtilities.hasPermission(context, permission2);
    }

    public static boolean isServiceDefined(@NonNull Context context, @NonNull Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        List list = context.getPackageManager().queryIntentServices(intent, 65536);
        return list.size() > 0;
    }

    public static String getContextData(@NonNull List<BasicData> dataPlugins) {
        if (dataPlugins == null) {
            return "[]";
        }
        String json = "[";
        for (int i = 0; i < dataPlugins.size(); ++i) {
            String dataToSendJson = dataPlugins.get(i).toString();
            json = json + dataToSendJson;
            if (i >= dataPlugins.size() - 1) continue;
            json = json + ",";
        }
        json = json + "]";
        return json;
    }

    private static boolean hasPermission(Context context, String permission2) {
        try {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                PackageInfo info = manager.getPackageInfo(context.getPackageName(), 4096);
                if (info.requestedPermissions != null) {
                    for (String p : info.requestedPermissions) {
                        if (!p.equals(permission2)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

