/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.network;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.network.NetworkConnectionType;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkData
extends ContextData
implements Parcelable {
    private NetworkConnectionType connectionType;
    private String ssid;
    private boolean isConnected;
    public static final Parcelable.Creator<NetworkData> CREATOR = new Parcelable.Creator<NetworkData>(){

        public NetworkData createFromParcel(Parcel in) {
            return new NetworkData(in);
        }

        public NetworkData[] newArray(int size) {
            return new NetworkData[size];
        }
    };

    public NetworkData() {
    }

    public NetworkData(Parcel in) {
        this.connectionType = NetworkConnectionType.fromKey(in.readInt());
        this.ssid = in.readString();
        this.isConnected = in.readInt() == 1;
        this.setTime(in.readLong());
    }

    public NetworkData(String ssid, boolean isConnected) {
        this.connectionType = NetworkConnectionType.WIFI;
        this.ssid = ssid;
        this.isConnected = isConnected;
    }

    public NetworkData(int type, String ssid, boolean isConnected) {
        this.connectionType = NetworkConnectionType.fromKey(type);
        this.ssid = ssid;
        this.isConnected = isConnected;
    }

    public NetworkData(@NonNull Context mContext, @NonNull NetworkInfo activeNetwork) {
        if (mContext != null && activeNetwork != null) {
            this.connectionType = NetworkConnectionType.fromKey(this.getType(activeNetwork).getKey());
            this.isConnected = this.isConnected(activeNetwork);
            this.ssid = this.getSSID(mContext, activeNetwork);
        } else {
            this.connectionType = NetworkConnectionType.UNKNOWN;
            this.isConnected = false;
            this.ssid = "";
        }
    }

    public NetworkConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getSsid() {
        return this.ssid;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("connectionType", this.connectionType.getKey());
            object.put("ssid", (Object)this.ssid);
            object.put("isConnected", this.isConnected);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            this.connectionType = NetworkConnectionType.fromKey(jsonObj.getInt("connectionType"));
            this.ssid = jsonObj.getString("ssid");
            this.isConnected = jsonObj.getBoolean("isConnected");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkData that = (NetworkData)o;
        if (this.connectionType != that.connectionType) {
            return false;
        }
        if (!this.ssid.equals(that.ssid)) {
            return false;
        }
        return this.isConnected == that.isConnected;
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.network";
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.connectionType.getKey());
        dest.writeString(this.ssid);
        dest.writeInt(this.isConnected ? 1 : 0);
        dest.writeLong(this.getTime());
    }

    boolean isConnected(NetworkInfo activeNetwork) {
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    NetworkConnectionType getType(NetworkInfo activeNetwork) {
        NetworkConnectionType connectionType = NetworkConnectionType.NONE;
        if (activeNetwork != null && activeNetwork.isConnected()) {
            connectionType = activeNetwork.getType() == 0 ? this.connectionType(activeNetwork.getSubtype()) : (activeNetwork.getType() == 1 ? NetworkConnectionType.WIFI : NetworkConnectionType.UNKNOWN);
        }
        return connectionType;
    }

    String getSSID(Context context, NetworkInfo activeNetwork) {
        String ssid = "";
        if (activeNetwork != null && activeNetwork.isConnected() && activeNetwork.getType() == 1) {
            ssid = this.setSSID(context);
        }
        if (ssid.startsWith("\"") && ssid.endsWith("\"")) {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    String setSSID(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo info = wifiManager.getConnectionInfo();
        return info.getSSID();
    }

    NetworkConnectionType connectionType(int subType) {
        switch (subType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NetworkConnectionType._2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NetworkConnectionType._3G;
            }
            case 13: {
                return NetworkConnectionType._4G;
            }
        }
        return NetworkConnectionType.UNKNOWN;
    }
}

