/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.beacon;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.beacon.BeaconType;
import org.altbeacon.beacon.Beacon;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(tableName="beaconsActive")
public class BeaconActive
extends ContextData
implements Parcelable {
    @ColumnInfo(name="id1")
    private String id1;
    @ColumnInfo(name="id2")
    private String id2;
    @ColumnInfo(name="id3")
    private String id3;
    @ColumnInfo(name="type")
    private BeaconType type;
    @ColumnInfo(name="lastSeen")
    private long lastSeen;
    @ColumnInfo(name="isSent")
    private boolean isSent;
    @ColumnInfo(name="isInRange")
    private boolean isInRange;
    @ColumnInfo(name="id")
    @PrimaryKey
    @NonNull
    private String compositeID;
    public static final Parcelable.Creator<BeaconActive> CREATOR = new Parcelable.Creator<BeaconActive>(){

        public BeaconActive createFromParcel(Parcel in) {
            return new BeaconActive(in);
        }

        public BeaconActive[] newArray(int size) {
            return new BeaconActive[size];
        }
    };

    public BeaconActive() {
    }

    @Ignore
    protected BeaconActive(Parcel in) {
        this.id1 = in.readString();
        this.id2 = in.readString();
        this.type = BeaconType.fromValue(in.readString());
        switch (this.type) {
            case IBeacon: {
                this.id3 = in.readString();
            }
        }
        this.isSent = in.readInt() == 1;
        this.isInRange = in.readInt() == 1;
        this.lastSeen = in.readLong();
        String compositeID = this.id1;
        if (this.id2 != null) {
            compositeID = compositeID + "_" + this.id2;
        }
        if (this.type == BeaconType.IBeacon && this.id3 != null) {
            compositeID = compositeID + "_" + this.id3;
        }
        this.compositeID = compositeID;
    }

    @Ignore
    public BeaconActive(@NonNull BeaconType type, @NonNull String id1, String id2, String id3, long lastSeen) throws IllegalStateException {
        this.setBeaconType(type, id1, id2, id3);
        this.lastSeen = lastSeen;
        this.isSent = false;
        String compositeID = id1;
        if (id2 != null) {
            compositeID = compositeID + "_" + id2;
        }
        if (type == BeaconType.IBeacon && id3 != null) {
            compositeID = compositeID + "_" + id3;
        }
        this.compositeID = compositeID;
    }

    @Ignore
    public BeaconActive(Beacon beacon) {
        this.id1 = beacon.getId1().toString();
        if (beacon.getIdentifiers().size() > 1) {
            this.id2 = beacon.getId2().toString();
        }
        if (beacon.getIdentifiers().size() > 2) {
            this.id3 = beacon.getId3().toString();
            this.type = BeaconType.IBeacon;
        } else {
            this.type = BeaconType.Eddystone;
        }
        this.lastSeen = System.currentTimeMillis() / 1000L;
        this.isSent = false;
        String compositeID = this.id1;
        if (this.id2 != null) {
            compositeID = compositeID + "_" + this.id2;
        }
        if (this.type == BeaconType.IBeacon && this.id3 != null) {
            compositeID = compositeID + "_" + this.id3;
        }
        this.compositeID = compositeID;
    }

    public String getCompositeID() {
        return this.compositeID;
    }

    public String getId1() {
        return this.id1;
    }

    public String getId2() {
        return this.id2;
    }

    public String getId3() {
        return this.id3;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public BeaconType getType() {
        return this.type;
    }

    public boolean isInRange() {
        return this.isInRange;
    }

    public boolean isSent() {
        return this.isSent;
    }

    public void setCompositeID(String compositeID) {
        this.compositeID = compositeID;
    }

    public void setId1(String id1) {
        this.id1 = id1;
    }

    public void setId2(String id2) {
        this.id2 = id2;
    }

    public void setId3(String id3) {
        this.id3 = id3;
    }

    public void setInRange(boolean isRange) {
        this.isInRange = isRange;
    }

    public void setIsSent(boolean isSent) {
        this.isSent = isSent;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public void setTimestamp(long timestamp) {
        this.lastSeen = timestamp;
    }

    public void setType(BeaconType type) {
        this.type = type;
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.beacon";
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id1);
        dest.writeString(this.id2);
        dest.writeString(this.type.getValue());
        switch (this.type) {
            case IBeacon: {
                dest.writeString(this.id3);
            }
        }
        dest.writeInt(this.isSent ? 1 : 0);
        dest.writeInt(this.isInRange ? 1 : 0);
        dest.writeLong(this.lastSeen);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconActive that = (BeaconActive)o;
        return this.getCompositeID().equalsIgnoreCase(that.getCompositeID());
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            this.type = BeaconType.fromValue(jsonObj.getString("type"));
            this.isInRange = jsonObj.getBoolean("inRange");
            if (!jsonObj.isNull("majorID")) {
                this.id2 = jsonObj.getString("majorID");
                this.id3 = jsonObj.getString("minorID");
                this.id1 = jsonObj.getString("uuid");
            } else {
                this.id2 = jsonObj.getString("instance");
                this.id1 = jsonObj.getString("namespace");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            switch (this.type) {
                case IBeacon: {
                    object.put("majorID", (Object)this.id2);
                    object.put("minorID", (Object)this.id3);
                    object.put("uuid", (Object)this.id1);
                    break;
                }
                case Eddystone: {
                    object.put("instance", (Object)this.id2);
                    object.put("namespace", (Object)this.id1);
                }
            }
            object.put("type", (Object)this.type.getValue());
            object.put("inRange", this.isInRange());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    private void setBeaconType(BeaconType type, String id1, String id2, String id3) throws IllegalStateException {
        if (type == BeaconType.Eddystone && (id1 == null || id2 == null)) {
            throw new IllegalStateException("You have entered an invalid EddyStone Beacon");
        }
        if (type == BeaconType.IBeacon && (id1 == null || id2 == null || id3 == null)) {
            throw new IllegalStateException("You have entered an invalid iBeacon Beacon");
        }
        switch (type) {
            case Eddystone: {
                this.id1 = id1;
                this.id2 = id2;
                break;
            }
            case IBeacon: {
                this.id1 = id1;
                this.id2 = id2;
                this.id3 = id3;
            }
        }
        this.type = type;
    }
}

