/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.battery;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.flybits.context.models.ContextData;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryData
extends ContextData
implements Parcelable {
    private boolean isCharging;
    private int percentage;
    public static final Parcelable.Creator<BatteryData> CREATOR = new Parcelable.Creator<BatteryData>(){

        public BatteryData createFromParcel(Parcel in) {
            return new BatteryData(in);
        }

        public BatteryData[] newArray(int size) {
            return new BatteryData[size];
        }
    };

    public BatteryData() {
    }

    protected BatteryData(Parcel in) {
        this.percentage = in.readInt();
        this.isCharging = in.readInt() == 1;
        this.setTime(in.readLong());
    }

    public BatteryData(boolean isCharging, int percentage) {
        this.isCharging = isCharging;
        this.percentage = percentage;
    }

    public BatteryData(@NonNull Context baseContext, @NonNull IntentFilter ifilter) {
        if (baseContext != null && ifilter != null) {
            this.percentage = this.getBatteryLife(baseContext, ifilter);
            this.isCharging = this.isBatteryCharging(baseContext, ifilter);
        }
    }

    public int getPercentage() {
        return this.percentage;
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("isCharging", this.isCharging);
            object.put("percentage", this.percentage);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            this.percentage = jsonObj.getInt("percentage");
            this.isCharging = jsonObj.getBoolean("isCharging");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.battery";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatteryData that = (BatteryData)o;
        if (this.percentage != that.percentage) {
            return false;
        }
        return this.isCharging == that.isCharging;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.percentage);
        dest.writeInt(this.isCharging ? 1 : 0);
        dest.writeLong(this.getTime());
    }

    int getBatteryLife(Context context, IntentFilter filter) {
        if (context == null || filter == null) {
            return -1;
        }
        Intent batteryStatus = context.registerReceiver(null, filter);
        float batteryLifePercentage = -1.0f;
        if (batteryStatus != null) {
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            batteryLifePercentage = (float)level / (float)scale;
        }
        return (int)(batteryLifePercentage * 100.0f);
    }

    boolean isBatteryCharging(Context context, IntentFilter filter) {
        if (context == null || filter == null) {
            return false;
        }
        Intent batteryStatus = context.registerReceiver(null, filter);
        if (batteryStatus != null) {
            int status = batteryStatus.getIntExtra("status", -1);
            return status == 2 || status == 5;
        }
        return false;
    }
}

