/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import org.json.JSONArray;
import org.json.JSONException;

@Entity(tableName="contextData")
public class BasicData
implements Parcelable {
    @PrimaryKey
    @ColumnInfo(name="contextID")
    @NonNull
    private String dataTypeID;
    @ColumnInfo(name="isSent")
    private boolean isSent;
    @ColumnInfo(name="lastUpdated")
    private long timestamp;
    @ColumnInfo(name="data")
    private String valueAsString;
    public static final Parcelable.Creator<BasicData> CREATOR = new Parcelable.Creator<BasicData>(){

        public BasicData createFromParcel(Parcel in) {
            return new BasicData(in);
        }

        public BasicData[] newArray(int size) {
            return new BasicData[size];
        }
    };

    public BasicData() {
    }

    @Ignore
    public BasicData(BasicData object) {
        this.dataTypeID = object.dataTypeID;
        this.timestamp = object.timestamp;
        this.isSent = object.isSent;
        this.valueAsString = object.valueAsString;
    }

    @Ignore
    public BasicData(String dataTypeID, long timestamp, boolean isSent, String valueAsString) {
        this.dataTypeID = dataTypeID;
        this.timestamp = timestamp;
        this.isSent = isSent;
        this.valueAsString = valueAsString;
    }

    @Ignore
    public BasicData(Parcel in) {
        this.timestamp = in.readLong();
        this.dataTypeID = in.readString();
        this.isSent = in.readInt() == 1;
        this.valueAsString = in.readString();
    }

    public String getDataTypeID() {
        return this.dataTypeID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public boolean isSent() {
        return this.isSent;
    }

    public void setDataTypeID(String dataTypeID) {
        this.dataTypeID = dataTypeID;
    }

    public void setSent(boolean sent) {
        this.isSent = sent;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValueAsString(String valueAsString) {
        this.valueAsString = valueAsString;
    }

    public String toString() {
        try {
            JSONArray jsonObj = new JSONArray(this.valueAsString);
            return "{\"timestamp\" : " + this.timestamp + ", \"dataTypeID\" : \"" + this.dataTypeID + "\", \"values\" : " + this.valueAsString + "}";
        }
        catch (JSONException jSONException) {
            return "{\"timestamp\" : " + this.timestamp + ", \"dataTypeID\" : \"" + this.dataTypeID + "\", \"value\" : " + this.valueAsString + "}";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicData basicData = (BasicData)o;
        return !(this.valueAsString == null ? basicData.valueAsString != null : !this.valueAsString.equals(basicData.valueAsString));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.timestamp);
        out.writeString(this.dataTypeID);
        out.writeInt(this.isSent ? 1 : 0);
        out.writeString(this.valueAsString);
    }
}

