/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.context.db.dao.DBPluginDAO;
import com.flybits.context.models.internal.Plugin;
import java.util.ArrayList;
import java.util.List;

public final class DBPluginDAO_Impl
implements DBPluginDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPlugin;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPlugin;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPlugin;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public DBPluginDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPlugin = new EntityInsertionAdapter<Plugin>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `plugin`(`contextID`,`refreshTime`,`isSupported`,`className`,`isEnabled`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Plugin value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                stmt.bindLong(2, value.getRefreshRate());
                int _tmp = value.isSupported() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getClassName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getClassName());
                }
                int _tmp_1 = value.isEnabled() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
            }
        };
        this.__deletionAdapterOfPlugin = new EntityDeletionOrUpdateAdapter<Plugin>(__db){

            public String createQuery() {
                return "DELETE FROM `plugin` WHERE `contextID` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Plugin value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
            }
        };
        this.__updateAdapterOfPlugin = new EntityDeletionOrUpdateAdapter<Plugin>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `plugin` SET `contextID` = ?,`refreshTime` = ?,`isSupported` = ?,`className` = ?,`isEnabled` = ? WHERE `contextID` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Plugin value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                stmt.bindLong(2, value.getRefreshRate());
                int _tmp = value.isSupported() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getClassName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getClassName());
                }
                int _tmp_1 = value.isEnabled() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                if (value.getId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM plugin";
                return "DELETE FROM plugin";
            }
        };
    }

    @Override
    public void insert(Plugin ... plugins) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPlugin.insert((Object[])plugins);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Plugin plugin) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPlugin.handle((Object)plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Plugin ... plugin) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPlugin.handleMultiple((Object[])plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Plugin> getAll() {
        String _sql = "Select * from plugin";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from plugin", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("contextID");
            int _cursorIndexOfRefreshRate = _cursor.getColumnIndexOrThrow("refreshTime");
            int _cursorIndexOfIsSupported = _cursor.getColumnIndexOrThrow("isSupported");
            int _cursorIndexOfClassName = _cursor.getColumnIndexOrThrow("className");
            int _cursorIndexOfIsEnabled = _cursor.getColumnIndexOrThrow("isEnabled");
            ArrayList<Plugin> _result = new ArrayList<Plugin>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Plugin _item = new Plugin();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                long _tmpRefreshRate = _cursor.getLong(_cursorIndexOfRefreshRate);
                _item.setRefreshRate(_tmpRefreshRate);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSupported);
                boolean _tmpIsSupported = _tmp != 0;
                _item.setSupported(_tmpIsSupported);
                String _tmpClassName = _cursor.getString(_cursorIndexOfClassName);
                _item.setClassName(_tmpClassName);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsEnabled);
                boolean _tmpIsEnabled = _tmp_1 != 0;
                _item.setEnabled(_tmpIsEnabled);
                _result.add(_item);
            }
            ArrayList<Plugin> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

