/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.context.db.converters.BeaconTypeConverter;
import com.flybits.context.db.dao.BeaconMonitoredDAO;
import com.flybits.context.plugins.beacon.BeaconMonitored;
import com.flybits.context.plugins.beacon.BeaconType;
import java.util.ArrayList;
import java.util.List;

public final class BeaconMonitoredDAO_Impl
implements BeaconMonitoredDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfBeaconMonitored;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfBeaconMonitored;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfBeaconMonitored;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public BeaconMonitoredDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBeaconMonitored = new EntityInsertionAdapter<BeaconMonitored>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `beaconsMonitored`(`type`,`uuid`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconMonitored value) {
                String _tmp = BeaconTypeConverter.beaconToInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getIdentifier() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getIdentifier());
                }
            }
        };
        this.__deletionAdapterOfBeaconMonitored = new EntityDeletionOrUpdateAdapter<BeaconMonitored>(__db){

            public String createQuery() {
                return "DELETE FROM `beaconsMonitored` WHERE `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconMonitored value) {
                if (value.getIdentifier() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getIdentifier());
                }
            }
        };
        this.__updateAdapterOfBeaconMonitored = new EntityDeletionOrUpdateAdapter<BeaconMonitored>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `beaconsMonitored` SET `type` = ?,`uuid` = ? WHERE `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BeaconMonitored value) {
                String _tmp = BeaconTypeConverter.beaconToInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getIdentifier() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getIdentifier());
                }
                if (value.getIdentifier() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getIdentifier());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM beaconsMonitored";
                return "DELETE FROM beaconsMonitored";
            }
        };
    }

    @Override
    public void insert(BeaconMonitored beacon) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBeaconMonitored.insert((Object)beacon);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(BeaconMonitored beacon) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfBeaconMonitored.handle((Object)beacon);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(BeaconMonitored ... beacons) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfBeaconMonitored.handleMultiple((Object[])beacons);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BeaconMonitored> getAll() {
        String _sql = "Select * from beaconsMonitored";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from beaconsMonitored", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("uuid");
            ArrayList<BeaconMonitored> _result = new ArrayList<BeaconMonitored>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                BeaconMonitored _item = new BeaconMonitored();
                String _tmp = _cursor.getString(_cursorIndexOfType);
                BeaconType _tmpType = BeaconTypeConverter.fromString(_tmp);
                _item.setType(_tmpType);
                String _tmpIdentifier = _cursor.getString(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                _result.add(_item);
            }
            ArrayList<BeaconMonitored> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

