package com.flybits.context.plugins.network;

import android.Manifest;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;

public class NetworkContextPluginService extends FlybitsContextPluginService {

    private final static String TAG_NETWORK_PLUGIN = "PluginNetwork";

    @Override
    public void initialize(Bundle bundle) {
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{Manifest.permission.ACCESS_WIFI_STATE, Manifest.permission.ACCESS_NETWORK_STATE};
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.appendTag(TAG_NETWORK_PLUGIN).d("Fetching Data...");
        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return new NetworkData(getBaseContext(), activeNetwork);
    }

    @Override
    public void onDestroy() {
        Logger.appendTag(TAG_NETWORK_PLUGIN).d("Destroyed");
        super.onDestroy();
    }

}
