package com.flybits.context.plugins.beacon;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import androidx.annotation.NonNull;

/**
 * The {@code BeaconMonitored} object is responsible for indicating the UUID (iBeacon) or Namespace
 * (EddyStone) that should be monitored subgroup by the monitoring service.
 */
@Entity(tableName = "beaconsMonitored")
public class BeaconMonitored {

    @ColumnInfo(name = "type")
    private BeaconType type;

    @ColumnInfo(name = "uuid")
    @PrimaryKey
    @NonNull
    private String identifier;

    public BeaconMonitored(){}

    /**
     * Constructor used to define the {@code BeaconMonitored} information about which Beacon
     * subgroup should be monitored by the SDK.
     *
     * @param type Whether or not the Beacon is {@link BeaconType#IBeacon} or
     *             {@link BeaconType#Eddystone}.
     * @param identifier The UUID for {@link BeaconType#IBeacon} or Namespace for
     *             {@link BeaconType#Eddystone}.
     */
    @Ignore
    public BeaconMonitored(BeaconType type, String identifier){
        this.type           = type;
        this.identifier     = identifier;
    }

    /**
     * Indicates whether or not the Beacon is {@link BeaconType#IBeacon} or
     * {@link BeaconType#Eddystone}.
     *
     * @return The {@link BeaconType}. Currently iBeacon and EddyStone beacons are only supported.
     */
    public BeaconType getType() {
        return type;
    }

    /**
     * The unique identifier that represents the Beacon subgroup that should be monitored.
     *
     * @return The UUID for {@link BeaconType#IBeacon} or Namespace for {@link BeaconType#Eddystone}.
     */
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Set the unique identifier of the {@code BeaconMonitored}. In the case that the
     * {@link #getType()} returns {@link BeaconType#Eddystone} this identifier is the
     * {@code namespace}. If {@link #getType()} returns {@link BeaconType#IBeacon} than the
     * identifier is the {@code uniqueID}.
     *
     * @param identifier The identifier of the Beacon for scanning purposes.
     */
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    /**
     * Sets the {@link BeaconType} that indicates which type of Beacon to monitor for.
     *
     * @param type The {@link BeaconType} that indicates which type of Beacon to monitor for.
     */
    public void setType(BeaconType type) {
        this.type = type;
    }
}
