package com.flybits.context.db.dao;

import androidx.room.*;
import com.flybits.context.models.internal.Plugin;

import java.util.List;

@Dao
public interface DBPluginDAO {

    @Query("Select * from plugin")
    List<Plugin> getAll();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(Plugin... plugins);

    @Delete
    void delete(Plugin plugin);

    @Update
    void update(Plugin... plugin);

    @Query("DELETE FROM plugin")
    void deleteAll();

}
