package com.flybits.context.db.dao;

import androidx.room.*;
import com.flybits.context.plugins.beacon.BeaconMonitored;

import java.util.List;

@Dao
public interface BeaconMonitoredDAO {

    @Query("Select * from beaconsMonitored")
    List<BeaconMonitored> getAll();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(BeaconMonitored beacon);

    @Delete
    void delete(BeaconMonitored beacon);

    @Update
    void update(BeaconMonitored... beacons);

    @Query("DELETE FROM beaconsMonitored")
    void deleteAll();
}
