package com.flybits.context.db.dao;

import androidx.room.*;
import com.flybits.context.plugins.beacon.BeaconActive;

import java.util.List;

@Dao
public interface BeaconActiveDAO {

    @Query("Select * from beaconsActive")
    List<BeaconActive> getAll();

    @Query("Select * from beaconsActive where isInRange != 0")
    List<BeaconActive> getAllNotInRange();

    @Query("Select * from beaconsActive where id = :compositeID")
    BeaconActive get(String compositeID);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(BeaconActive beacon);

    @Delete
    void delete(BeaconActive beacon);

    @Update
    void update(BeaconActive... beacons);

    @Query("DELETE from beaconsActive where isInRange = 0")
    void deleteBeaconsNotInRange();

    @Query("DELETE FROM beaconsActive")
    void deleteAll();
}
