package com.flybits.context;

import android.content.SharedPreferences;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextPriority;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;

import java.util.concurrent.TimeUnit;

public class ContextUploadingService extends GcmTaskService {

    private static final String _TAG                = "ContextUploadingService";
    public static final String PREF_REFRESH_RATE    = "updateRate-ContextUpload";

    @Override
    public void onInitializeTasks() {
        super.onInitializeTasks();

        SharedPreferences preferences   = ContextScope.getContextPreferences(getBaseContext());
        long numberOfSeconds = preferences.getLong(PREF_REFRESH_RATE, 3600);
        ContextManager.registerUploadingContext(getBaseContext(), ContextPriority.HIGH,
                numberOfSeconds, numberOfSeconds, TimeUnit.SECONDS);
    }

    @Override
    public int onRunTask(TaskParams taskParams) {

        Logger.setTag(_TAG).d("Starting Context Uploading...");
        ContextManager.flushContextData(getBaseContext(), null);
        Logger.setTag(_TAG).d("...Finished Context Uploading");
        return GcmNetworkManager.RESULT_SUCCESS;
    }

    @Override
    public void onDestroy() {
        Logger.setTag(_TAG).d("...Destroyed Context Uploading");
        super.onDestroy();
    }
}
