package com.flybits.context.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.context.models.RuleEvalutated;
import com.flybits.context.utils.RulesQueryParameters;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

public class RulesEvaluatedResult extends PagedResult<RuleEvalutated> {

    public RulesEvaluatedResult(Context context, QueryParameters parameters,
                                PagedResultCallback<RuleEvalutated> callback, ExecutorService service, Handler handler){
        super(context, parameters, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K parameters, @NotNull PagedResultCallback<RuleEvalutated> pagedResultCallback) {
        RuleEvalutated.get(getContext(), (RulesQueryParameters) parameters, pagedResultCallback);
    }
}
