/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.arch.persistence.room.Ignore;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.BasicData;
import com.flybits.context.utils.ContextUtilities;
import com.flybits.internal.DeboucerContextReporting;
import com.flybits.internal.Debounce;
import com.flybits.internal.Debouncer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class ContextData
implements Parcelable {
    @Ignore
    private long timeInSeconds;

    public ContextData() {
        this.setTime(System.currentTimeMillis() / 1000L);
    }

    public abstract boolean equals(Object var1);

    public abstract void fromJson(String var1);

    public long getTime() {
        return this.timeInSeconds;
    }

    public abstract String getPluginID();

    public void setTime(long time) {
        this.timeInSeconds = time;
    }

    public abstract String toJson();

    public BasicResult update(final Context context, final long timeInSec, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult basicResult = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                boolean isContextChanged = false;
                String pluginID = ContextData.this.getPluginID();
                BasicData dataFromCursor = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                if (dataFromCursor != null) {
                    if (dataFromCursor.getValueAsString() != null && !dataFromCursor.getValueAsString().equals(ContextData.this.toJson())) {
                        isContextChanged = true;
                        BasicData tempData = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                        tempData.setTimestamp(timeInSec);
                        tempData.setValueAsString(ContextData.this.toJson());
                        tempData.setSent(false);
                        Logger.setTag((String)"FlybitsContext").i("Update: " + ContextData.this.toJson());
                        ContextDatabase.getDatabase(context).basicDataDao().update(tempData);
                    }
                } else {
                    isContextChanged = true;
                    BasicData dataBasic = new BasicData(pluginID, timeInSec, false, ContextData.this.toJson());
                    Logger.setTag((String)"FlybitsContext").i("Insert: " + ContextData.this.toJson());
                    ContextDatabase.getDatabase(context).basicDataDao().insert(dataBasic);
                }
                if (isContextChanged) {
                    ContextUtilities.broadcastContextUpdate(context, ContextData.this, pluginID, timeInSec);
                    DeboucerContextReporting task = new DeboucerContextReporting(context);
                    Debouncer.getInstance().call((Debounce)task);
                }
                Result result = new Result(200, "");
                basicResult.setResult(result);
            }
        });
        return basicResult;
    }

    public BasicResult updateNow(final Context context, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult basicResult = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                boolean isContextChanged = false;
                String pluginID = ContextData.this.getPluginID();
                long currentTime = System.currentTimeMillis() / 1000L;
                BasicData dataFromCursor = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                if (dataFromCursor != null) {
                    if (dataFromCursor.getValueAsString() != null && !dataFromCursor.getValueAsString().equals(ContextData.this.toJson())) {
                        isContextChanged = true;
                        BasicData tempData = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                        tempData.setTimestamp(currentTime);
                        tempData.setValueAsString(ContextData.this.toJson());
                        tempData.setSent(false);
                        Logger.setTag((String)"FlybitsContext").i("Update: " + ContextData.this.toJson());
                        ContextDatabase.getDatabase(context).basicDataDao().update(tempData);
                    }
                } else {
                    isContextChanged = true;
                    BasicData dataBasic = new BasicData(pluginID, currentTime, false, ContextData.this.toJson());
                    Logger.setTag((String)"FlybitsContext").i("Insert: " + ContextData.this.toJson());
                    ContextDatabase.getDatabase(context).basicDataDao().insert(dataBasic);
                }
                if (isContextChanged) {
                    ContextUtilities.broadcastContextUpdate(context, ContextData.this, pluginID, currentTime);
                    ContextManager.flushContextData(context, null);
                }
                Result result = new Result(200, "");
                basicResult.setResult(result);
            }
        });
        return basicResult;
    }

    public String toString() {
        return this.toJson();
    }
}

