package com.flybits.internal;


import android.content.Context;

import com.flybits.context.ContextManager;

public class DeboucerContextReporting extends Debounce{

    private Context context;

    public DeboucerContextReporting(Context context){
        this.context    = context;
    }


    @Override
    public String getKey() {
        return "CONTEXT_UPLOAD";
    }

    @Override
    public void doSomething() {
        ContextManager.flushContextData(context, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (!(o instanceof Debounce)){
            return false;
        }

        Debounce that = (Debounce) o;
        return that.getKey().equals(getKey());

    }

    @Override
    public int hashCode(){
        return 87;
    }


}
