package com.flybits.context.plugins.fitness;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.context.models.ContextData;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The {@code FitnessData} that contains information about the fitness status of the user.
 * Currently, the following data is being collected as Fitness data;
 * <ul>
 *     <li>Steps Taken</li>
 * </ul>
 */
public class FitnessData extends ContextData implements Parcelable {

    private long steps;

    /**
     * Default constructor needed for generics instantiation
     */
    public FitnessData(){}

    /**
     * Constructor used to define the {@code FitnessData} based on a preset definition of the number
     * of steps the user's device has detected.
     *
     * @param steps The number of steps detected by the user.
     */
    public FitnessData(long steps){
        super();
        this.steps  = steps;
    }

    /**
     * Constructor used for un-flattening a {@code FitnessData} parcel.
     *
     * @param in the parcel that contains the un-flattened {@code FitnessData} parcel.
     */
    protected FitnessData(Parcel in){
        super();
        this.steps = in.readLong();
        setTime(in.readLong());
    }

    /**
     * Get the number of steps detected by the device.
     *
     * @return The number of steps.
     */
    public long getSteps(){
        return steps;
    }

    @Override
    public String toJson() {

        JSONObject object=new JSONObject();
        try {
            object.put("steps", steps);
        }catch (JSONException exception){}

        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj  = new JSONObject(json);
            steps               = jsonObj.getLong("steps");

        }catch (JSONException exception){}
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FitnessData that = (FitnessData) o;
        return steps == that.steps;
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.fitness";
    }

    @Override
    public String toString(){
        return toJson();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(steps);
        dest.writeLong(getTime());
    }

    /**
     * Parcelable.Creator that instantiates {@code FitnessData} objects
     */
    public static final Creator<FitnessData> CREATOR = new Creator<FitnessData>() {
        public FitnessData createFromParcel(Parcel in) {
            return new FitnessData(in);
        }

        public FitnessData[] newArray(int size) {
            return new FitnessData[size];
        }
    };
}
