package com.flybits.context.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.context.models.internal.Plugin;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

public class ContextPluginResult extends PagedResult<Plugin> {

    public ContextPluginResult(Context context, QueryParameters parameters,
                               PagedResultCallback<Plugin> callback, ExecutorService service, Handler handler){
        super(context, parameters, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K parameters, @NotNull PagedResultCallback<Plugin> pagedResultCallback) {
        Plugin.get(getContext(), parameters, pagedResultCallback);

    }
}
