package com.flybits.context.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.flybits.context.models.BasicData;

import java.util.List;

@Dao
public interface BasicDataDAO {

    @Query("Select * from contextData")
    List<BasicData> getAll();

    @Query("Select * from contextData where isSent = 0")
    List<BasicData> getAllNotSent();

    @Query("Select * from contextData where contextID = :contextID")
    BasicData get(String contextID);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(BasicData plugins);

    @Delete
    void delete(BasicData plugin);

    @Update
    void update(BasicData... plugin);
}
