package com.flybits.context.db;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;

import com.flybits.context.db.converters.BeaconTypeConverter;
import com.flybits.context.db.dao.BasicDataDAO;
import com.flybits.context.db.dao.BeaconActiveDAO;
import com.flybits.context.db.dao.BeaconMonitoredDAO;
import com.flybits.context.db.dao.DBPluginDAO;
import com.flybits.context.db.dao.RuleEvaluationDAO;
import com.flybits.context.models.BasicData;
import com.flybits.context.models.RuleEvalutated;
import com.flybits.context.models.internal.Plugin;
import com.flybits.context.plugins.beacon.BeaconActive;
import com.flybits.context.plugins.beacon.BeaconMonitored;

@Database(entities = {Plugin.class, RuleEvalutated.class, BasicData.class, BeaconActive.class, BeaconMonitored.class}, version = 2)
@TypeConverters({BeaconTypeConverter.class})
public abstract class ContextDatabase extends RoomDatabase {

    private static ContextDatabase INSTANCE;

    public abstract DBPluginDAO pluginDao();
    public abstract RuleEvaluationDAO ruleDao();
    public abstract BasicDataDAO basicDataDao();
    public abstract BeaconActiveDAO beaconActiveDao();
    public abstract BeaconMonitoredDAO beaconMonitoredDao();

    public static ContextDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE =
                    Room.databaseBuilder(context, ContextDatabase.class, "flybits-context-db")
                            .fallbackToDestructiveMigration()
                            .build();
                   /*
                    Room.inMemoryDatabaseBuilder(context.getApplicationContext(), ContextDatabase.class)
                            // To simplify the codelab, allow queries on the main thread.
                            // Don't do this on a real app! See PersistenceBasicSample for an example.
                            .allowMainThreadQueries()
                            .build();
                    */
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

}