/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins;

import android.app.ActivityManager;
import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.ContextScope;
import com.flybits.context.ReservedContextPlugin;
import com.flybits.context.exceptions.InvalidContextPluginException;
import com.flybits.context.plugins.ContextPlugin;
import com.flybits.context.plugins.activity.ActivityContextPluginService;
import com.flybits.context.plugins.battery.BatteryContextPluginService;
import com.flybits.context.plugins.beacon.BeaconScanningService;
import com.flybits.context.plugins.carrier.CarrierContextPluginService;
import com.flybits.context.plugins.fitness.FitnessContextPluginService;
import com.flybits.context.plugins.language.LanguageContextPluginService;
import com.flybits.context.plugins.location.LocationContextPluginService;
import com.flybits.context.plugins.network.NetworkContextPluginService;
import com.flybits.context.plugins.weather.WeatherContextPluginService;
import com.flybits.context.services.FlybitsContextPluginService;
import com.flybits.context.utils.ContextUtilities;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import java.util.concurrent.TimeUnit;

public class FlybitsContextPlugin
implements ContextPlugin {
    public static final String EXTRA_NOTIFICATION = "flybits_extra_notification";
    public static final String EXTRA_MINIMUM_REFRESH_TIME = "flybits_minimum_refresh_time";
    private String _TAG = "FlybitsContextPlugin";
    private long timeInSecondsFlex;
    private long timeInSeconds;
    private Notification foregroundServiceNotification;
    private Bundle extras;
    private Class<? extends FlybitsContextPluginService> taskServiceBackground;

    private FlybitsContextPlugin(Builder builder) {
        if (builder.extras != null) {
            this.extras = builder.extras;
        }
        if (builder.taskServiceBackground != null) {
            this.taskServiceBackground = builder.taskServiceBackground;
        }
        this.timeInSecondsFlex = builder.timeInSecondsFlex;
        this.timeInSeconds = builder.timeInSeconds;
        this.foregroundServiceNotification = builder.foregroundServiceNotification;
        if (this.timeInSeconds != (long)Builder.GRETZKYS_UNIQUE_ID && this.timeInSeconds < 60L && this.foregroundServiceNotification == null) {
            throw new IllegalStateException("foregroundServiceNotification cannot be null if refresh time is less than 60 seconds. Use Builder.setForegroundServiceNotification().");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlybitsContextPlugin)) {
            return false;
        }
        FlybitsContextPlugin another = (FlybitsContextPlugin)o;
        return another.getService().getSimpleName().equals(this.getService().getSimpleName());
    }

    Bundle getExtras() {
        if (this.extras == null) {
            return Bundle.EMPTY;
        }
        return this.extras;
    }

    long getRefreshTime() {
        return this.timeInSeconds;
    }

    long getRefreshTimeFlex() {
        return this.timeInSecondsFlex;
    }

    boolean isCustomRefreshSet() {
        return this.timeInSeconds < 60L;
    }

    public Class<? extends FlybitsContextPluginService> getService() {
        return this.taskServiceBackground;
    }

    @Override
    public void onStart(Context mContext) {
        Logger.setTag((String)"FlybitsContextPlugin").d("onStart()");
        if (this.isCustomRefreshSet()) {
            if (!this.isServiceRunning(mContext, this.getService())) {
                Intent intent = new Intent(mContext, this.getService());
                Bundle extras = this.setBundle();
                extras.putParcelable(EXTRA_NOTIFICATION, (Parcelable)this.foregroundServiceNotification);
                intent.putExtras(extras);
                ContextCompat.startForegroundService((Context)mContext, (Intent)intent);
            }
        } else {
            SharedPreferences.Editor preferences = ContextScope.getContextPreferences(mContext).edit();
            preferences.putLong(FlybitsContextPlugin.getPrefName(this.getService()), this.getRefreshTime());
            preferences.apply();
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            PeriodicTask.Builder task = new PeriodicTask.Builder().setTag(this.getService().getSimpleName()).setExtras(this.setBundle()).setPeriod(this.getRefreshTime()).setUpdateCurrent(true).setPersisted(true).setFlex(this.getRefreshTimeFlex()).setRequiredNetwork(2).setService(this.getService());
            mGcmNetworkManager.schedule((Task)task.build());
        }
        Logger.setTag((String)this._TAG).d("Activated: " + this.getService().getSimpleName());
    }

    @Override
    public void onStop(Context mContext) {
        Logger.setTag((String)"FlybitsContextPlugin").d("onStop()");
        if (this.isCustomRefreshSet()) {
            if (this.isServiceRunning(mContext, this.getService())) {
                Intent intent = new Intent(mContext, this.getService());
                mContext.stopService(intent);
            }
        } else {
            Intent intent = new Intent(mContext, this.getService());
            if (ContextUtilities.isServiceDefined(mContext, intent)) {
                GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
                try {
                    mGcmNetworkManager.cancelTask(this.getService().getSimpleName(), this.getService());
                }
                catch (IllegalArgumentException ex) {
                    Logger.exception((String)"FlybitsContextPlugin.stop", (Exception)ex);
                }
            }
        }
        Logger.setTag((String)this._TAG).d("Deactivated: " + this.getService().getSimpleName());
    }

    @Override
    public void onRefresh(Context mContext) {
        Logger.setTag((String)"FlybitsContextPlugin").d("onRefresh()");
        if (this.isCustomRefreshSet()) {
            if (!this.isServiceRunning(mContext, this.getService())) {
                Intent intent = new Intent(mContext, this.getService());
                Bundle extras = this.setBundle();
                extras.putParcelable(EXTRA_NOTIFICATION, (Parcelable)this.foregroundServiceNotification);
                intent.putExtras(extras);
                ContextCompat.startForegroundService((Context)mContext, (Intent)intent);
            }
        } else {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            OneoffTask.Builder task = new OneoffTask.Builder().setTag(this.getService().getSimpleName()).setExtras(this.setBundle()).setExecutionWindow(this.getRefreshTime(), this.getRefreshTimeFlex()).setService(this.getService()).setUpdateCurrent(true);
            mGcmNetworkManager.schedule((Task)task.build());
        }
    }

    private boolean isServiceRunning(Context mContext, Class<?> serviceClass) {
        ActivityManager activityManager = (ActivityManager)mContext.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : activityManager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            Logger.setTag((String)this._TAG).d("unregisterUploadingContext Completed");
            Logger.setTag((String)this._TAG).d("isServiceRunning: " + service.service.getClassName() + ", true");
            return true;
        }
        Logger.setTag((String)this._TAG).d("isServiceRunning: " + serviceClass.getName() + ", false");
        return false;
    }

    private Bundle setBundle() {
        Bundle bundle = this.getExtras() == Bundle.EMPTY ? new Bundle() : this.getExtras();
        bundle.putLong(EXTRA_MINIMUM_REFRESH_TIME, this.getRefreshTime());
        return bundle;
    }

    public static String getPrefName(Class classToBeSaved) {
        return "ContextPlugin-" + classToBeSaved.getSimpleName();
    }

    public static class Builder {
        private static int GRETZKYS_UNIQUE_ID = -99;
        long timeInSeconds = 60L;
        Notification foregroundServiceNotification = null;
        long timeInSecondsFlex = 60L;
        Bundle extras;
        Class<? extends FlybitsContextPluginService> taskServiceBackground;

        public Builder(Class<? extends FlybitsContextPluginService> classObj) {
            this.setService(classObj);
        }

        public Builder(ReservedContextPlugin plugin) {
            switch (plugin) {
                case BATTERY: {
                    this.setService(BatteryContextPluginService.class);
                    break;
                }
                case CARRIER: {
                    this.setService(CarrierContextPluginService.class);
                    break;
                }
                case LOCATION: {
                    this.setService(LocationContextPluginService.class);
                    break;
                }
                case WEATHER: {
                    this.setService(WeatherContextPluginService.class);
                    break;
                }
                case NETWORK_CONNECTIVITY: {
                    this.setService(NetworkContextPluginService.class);
                    break;
                }
                case ACTIVITY: {
                    this.setService(ActivityContextPluginService.class);
                    break;
                }
                case LANGUAGE: {
                    this.setService(LanguageContextPluginService.class);
                    break;
                }
                case FITNESS: {
                    this.setService(FitnessContextPluginService.class);
                    break;
                }
                case BEACON: {
                    this.setService(BeaconScanningService.class);
                    this.timeInSeconds = GRETZKYS_UNIQUE_ID;
                }
            }
        }

        public FlybitsContextPlugin build() throws InvalidContextPluginException {
            if (this.timeInSeconds == 0L) {
                this.timeInSeconds = 60L;
            }
            if (this.timeInSecondsFlex == 0L) {
                this.timeInSecondsFlex = 60L;
            }
            return new FlybitsContextPlugin(this);
        }

        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        public Builder setRefreshTime(long timeUnit, long flexTimeUnit, TimeUnit unit) {
            if (this.timeInSeconds != (long)GRETZKYS_UNIQUE_ID) {
                this.timeInSeconds = unit.toSeconds(timeUnit);
                this.timeInSecondsFlex = unit.toSeconds(flexTimeUnit);
            }
            return this;
        }

        public Builder setForegroundServiceNotification(Notification foregroundServiceNotification) {
            this.foregroundServiceNotification = foregroundServiceNotification;
            return this;
        }

        void setService(Class<? extends FlybitsContextPluginService> classObj) {
            this.taskServiceBackground = classObj;
        }
    }
}

