/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;
import com.flybits.context.db.converters.BeaconTypeConverter;
import com.flybits.context.db.dao.BasicDataDAO;
import com.flybits.context.db.dao.BeaconActiveDAO;
import com.flybits.context.db.dao.BeaconMonitoredDAO;
import com.flybits.context.db.dao.DBPluginDAO;
import com.flybits.context.db.dao.RuleEvaluationDAO;
import com.flybits.context.models.BasicData;
import com.flybits.context.models.RuleEvalutated;
import com.flybits.context.models.internal.Plugin;
import com.flybits.context.plugins.beacon.BeaconActive;
import com.flybits.context.plugins.beacon.BeaconMonitored;

@Database(entities={Plugin.class, RuleEvalutated.class, BasicData.class, BeaconActive.class, BeaconMonitored.class}, version=2)
@TypeConverters(value={BeaconTypeConverter.class})
public abstract class ContextDatabase
extends RoomDatabase {
    private static ContextDatabase INSTANCE;

    public abstract DBPluginDAO pluginDao();

    public abstract RuleEvaluationDAO ruleDao();

    public abstract BasicDataDAO basicDataDao();

    public abstract BeaconActiveDAO beaconActiveDao();

    public abstract BeaconMonitoredDAO beaconMonitoredDao();

    public static ContextDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (ContextDatabase)Room.databaseBuilder((Context)context, ContextDatabase.class, (String)"flybits-context-db").fallbackToDestructiveMigration().build();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }
}

