package com.flybits.context.plugins.fitness;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.ContextManager;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Scopes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.fitness.Fitness;

import java.util.concurrent.TimeUnit;

public class FitnessContextPluginService extends FlybitsContextPluginService implements
        GoogleApiClient.ConnectionCallbacks,
        GoogleApiClient.OnConnectionFailedListener, IFitnessData {

    private GoogleApiClient mGoogleApiClient;
    private final static String _TAG = "PluginFitness";

    @Override
    public void initialize(Bundle bundle) {

        if (mGoogleApiClient == null) {
            mGoogleApiClient = new GoogleApiClient.Builder(this)
                    .addApi(Fitness.HISTORY_API)
                    .addScope(new Scope(Scopes.FITNESS_ACTIVITY_READ_WRITE))
                    .addConnectionCallbacks(this)
                    .addOnConnectionFailedListener(this)
                    .build();
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {

        Logger.setTag(_TAG).d("Fetching Data ...");

        if (mGoogleApiClient != null) {
            if (!mGoogleApiClient.isConnected()) {
                mGoogleApiClient.blockingConnect(10, TimeUnit.SECONDS);
            }

            if (mGoogleApiClient.isConnected()) {
                FitnessUtils.getStepsToday(mGoogleApiClient, this);
            }
        }
        wait(5, TimeUnit.SECONDS);

        return null;
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        Logger.setTag(_TAG).d("GoogleAPIClient: onConnected");
    }

    @Override
    public void onConnectionSuspended(int i) {
        Logger.setTag(_TAG).w("GoogleAPIClient: onConnectionSuspended: " + i);
    }

    @Override
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Logger.setTag(_TAG).e("GoogleAPIClient: onConnectionFailed: + " + connectionResult);
    }

    @Override
    public void onDestroy() {
        Logger.setTag(_TAG).d("...Destroyed");
        if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
            mGoogleApiClient.disconnect();
        }
        super.onDestroy();
    }

    @Override
    public void onGetSteps(long steps) {
        FitnessData data     = new FitnessData(steps);
        long timeInSec              = (data.getTime() > 0) ? data.getTime() : (System.currentTimeMillis() / 1000);
        data.update(getBaseContext(), timeInSec, null);
    }

    @Override
    public void onCancel() {}

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }

}
