/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextPluginsService;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.ContextPriority;
import com.flybits.context.models.internal.Plugin;
import com.flybits.context.services.FlybitsContextPluginService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ContextScope
extends FlybitsScope {
    public static final String ROOT = "/context";
    private String _TAG = "ContextScope";
    private long timeToUploadContext;
    private long timeToRetrieveRules;
    private long timeToRetrieveContextPlugins;
    private boolean autoStartContextCollection;
    private HashMap<String, String> classesAsString;
    public static ContextScope SCOPE = new ContextScope();

    ContextScope() {
        super("ContextSDK");
    }

    public ContextScope(long timeToUploadContext, @NonNull TimeUnit unit) {
        this(timeToUploadContext, -1L, unit, -1L, false, null);
    }

    @Deprecated
    public ContextScope(long timeToUploadContext, @NonNull TimeUnit unit, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        this(timeToUploadContext, -1L, unit, -1L, true, classes);
    }

    public ContextScope(long timeToUploadContext, long timeToRetrieveContextPlugins, @NonNull TimeUnit unit, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        this(timeToUploadContext, -1L, unit, timeToRetrieveContextPlugins, true, classes);
    }

    private ContextScope(long timeToUploadContext, long timeToRetrieveRules, @NonNull TimeUnit unit, long timeToRetrieveContextPlugins, boolean autoStartContextCollection, HashMap<String, Class<? extends FlybitsContextPluginService>> classes) {
        super("CONTEXT_SDK");
        this.autoStartContextCollection = autoStartContextCollection;
        this.classesAsString = new HashMap();
        if (timeToUploadContext != -1L) {
            this.timeToUploadContext = unit.toMinutes(timeToUploadContext);
            if (this.timeToUploadContext == 0L) {
                this.timeToUploadContext = 1L;
            }
        } else {
            this.timeToUploadContext = -1L;
        }
        if (timeToRetrieveRules != -1L) {
            this.timeToRetrieveRules = unit.toMinutes(timeToRetrieveRules);
            if (this.timeToRetrieveRules == 0L) {
                this.timeToRetrieveRules = 1L;
            }
        } else {
            this.timeToRetrieveRules = -1L;
        }
        if (timeToRetrieveContextPlugins != -1L) {
            this.timeToRetrieveContextPlugins = unit.toSeconds(timeToRetrieveContextPlugins);
            if (this.timeToRetrieveContextPlugins == 0L) {
                this.timeToRetrieveContextPlugins = 86400L;
            }
        } else {
            this.timeToRetrieveContextPlugins = 86400L;
        }
        if (autoStartContextCollection && classes != null && classes.size() > 0) {
            Iterator<Map.Entry<String, Class<? extends FlybitsContextPluginService>>> it = classes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Class<? extends FlybitsContextPluginService>> pair = it.next();
                this.classesAsString.put(pair.getKey(), pair.getValue().getCanonicalName());
                it.remove();
            }
        }
    }

    long getTimeToUploadContext() {
        return this.timeToUploadContext;
    }

    long getTimeToRetrieveRules() {
        return this.timeToRetrieveRules;
    }

    boolean isAutoStartContextCollection() {
        return this.autoStartContextCollection;
    }

    public void onConnected(Context context, User user) {
        Logger.setTag((String)this._TAG).d("onConnected: " + user);
        if (this.timeToUploadContext > 0L) {
            this.startUploadingContext(context);
        }
        if (this.timeToRetrieveRules > 0L) {
            this.startRetrievingRules(context);
        }
        if (this.autoStartContextCollection) {
            ContextManager.registerForPluginUpdates(context, this.classesAsString, this.timeToRetrieveContextPlugins);
        }
    }

    public void onDisconnected(Context context, String jwtToken) {
        Logger.setTag((String)this._TAG).d("onDisconnected");
        ContextManager.unregisterUploadingContext(context);
        ContextManager.unregisterFromRuleCollection(context);
        ContextManager.unregisterPluginContext(context);
        this.clearContextPreferences(context);
        List<Plugin> listOfOldPlugins = ContextDatabase.getDatabase(context).pluginDao().getAll();
        for (Plugin plugin : listOfOldPlugins) {
            ContextPluginsService.stopContextPlugin(context, this.classesAsString, plugin);
        }
    }

    public void onAccountDestroyed(Context context, String jwtToken) {
        Logger.setTag((String)this._TAG).d("onAccountDestroyed");
        this.onDisconnected(context, jwtToken);
    }

    void startUploadingContext(Context context) {
        Logger.setTag((String)this._TAG).d("Activating Contextual Uploading");
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(context).edit();
        preferences.putLong("updateRate-ContextUpload", TimeUnit.MINUTES.toSeconds(this.timeToUploadContext));
        preferences.apply();
        ContextManager.registerUploadingContext(context, ContextPriority.HIGH, this.timeToUploadContext, 1L, TimeUnit.MINUTES);
    }

    void startRetrievingRules(Context context) {
        Logger.setTag((String)this._TAG).d("Activating Contextual Uploading");
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(context).edit();
        preferences.putLong("updateRate-ContextRules", TimeUnit.MINUTES.toSeconds(this.timeToRetrieveRules));
        preferences.apply();
        ContextManager.registerForRules(context, this.timeToRetrieveRules, 1L, TimeUnit.MINUTES);
    }

    public static SharedPreferences getContextPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_CONTEXT", 0);
    }

    private void clearContextPreferences(Context context) {
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(context).edit();
        preferences.clear();
        preferences.apply();
    }
}

