/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.oauth;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessToken
implements Parcelable {
    private String provider;
    private String accessToken;
    private Long expiresAt;
    public static final Parcelable.Creator<AccessToken> CREATOR = new Parcelable.Creator<AccessToken>(){

        public AccessToken createFromParcel(Parcel in) {
            return new AccessToken(in);
        }

        public AccessToken[] newArray(int size) {
            return new AccessToken[size];
        }
    };

    protected AccessToken(Parcel in) {
        this.provider = in.readString();
        this.accessToken = in.readString();
        this.expiresAt = in.readLong();
    }

    public AccessToken(String provider, String accessToken, Long expiresAt) {
        this.provider = provider;
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getProvider() {
        return this.provider;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.provider);
        out.writeString(this.accessToken);
        out.writeLong(this.expiresAt.longValue());
    }

    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            if (!jsonObj.isNull("accessToken")) {
                this.accessToken = jsonObj.getString("accessToken");
            }
            if (!jsonObj.isNull("provider")) {
                this.provider = jsonObj.getString("provider");
            }
            if (!jsonObj.isNull("expiresAt")) {
                this.expiresAt = jsonObj.getLong("expiresAt");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            if (this.provider != null) {
                object.put("provider", (Object)this.provider);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            if (this.accessToken != null) {
                object.put("accessToken", (Object)this.accessToken);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            if (this.expiresAt != null) {
                object.put("expiresAt", (Object)this.expiresAt);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    public String toString() {
        return this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) {
            return false;
        }
        if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) {
            return false;
        }
        return this.expiresAt != null ? this.expiresAt.equals(that.expiresAt) : that.expiresAt == null;
    }
}

