/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.carrier;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.flybits.context.models.ContextData;
import org.json.JSONException;
import org.json.JSONObject;

public class CarrierData
extends ContextData
implements Parcelable {
    private String mcc;
    private String mnc;
    public static final Parcelable.Creator<CarrierData> CREATOR = new Parcelable.Creator<CarrierData>(){

        public CarrierData createFromParcel(Parcel in) {
            return new CarrierData(in);
        }

        public CarrierData[] newArray(int size) {
            return new CarrierData[size];
        }
    };

    public CarrierData() {
    }

    protected CarrierData(Parcel in) {
        this.mcc = in.readString();
        this.mnc = in.readString();
        this.setTime(in.readLong());
    }

    public CarrierData(String simOperator) {
        this.mcc = this.getSIM_MCC(simOperator);
        this.mnc = this.getSIM_MNC(simOperator);
    }

    public CarrierData(String mcc, String mnc) {
        this.mcc = mcc;
        this.mnc = mnc;
    }

    public String getMcc() {
        return this.mcc;
    }

    public String getMnc() {
        return this.mnc;
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            if (this.mcc != null) {
                object.put("mcc", (Object)this.mcc);
            }
            if (this.mnc != null) {
                object.put("mnc", (Object)this.mnc);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            if (!jsonObj.isNull("mcc")) {
                this.mcc = jsonObj.getString("mcc");
            }
            if (!jsonObj.isNull("mnc")) {
                this.mnc = jsonObj.getString("mnc");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarrierData that = (CarrierData)o;
        if (!this.mcc.equals(that.mcc)) {
            return false;
        }
        return this.mnc.equals(that.mnc);
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.carrier";
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mcc);
        dest.writeString(this.mnc);
        dest.writeLong(this.getTime());
    }

    String getSIM_MNC(String simOperator) {
        if (!TextUtils.isEmpty((CharSequence)simOperator)) {
            try {
                return String.valueOf(simOperator.substring(3));
            }
            catch (StringIndexOutOfBoundsException e) {
                return "";
            }
        }
        return "";
    }

    String getSIM_MCC(String simOperator) {
        if (!TextUtils.isEmpty((CharSequence)simOperator)) {
            try {
                return String.valueOf(simOperator.substring(0, 3));
            }
            catch (StringIndexOutOfBoundsException e) {
                return "";
            }
        }
        return "";
    }
}

