/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.activities.OAuthLoginBrowserActivity;
import com.flybits.context.plugins.ContextPlugin;
import com.flybits.context.plugins.oauth.AccessToken;
import com.flybits.context.plugins.oauth.IFlybitsOAuthCallback;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OAuthContextPlugin
implements ContextPlugin {
    public static final String API_CONTEXT_OAUTH = "/context/oauth";
    public static final String API_CONTEXT_OAUTH_ACCESSTOKEN = "/context/oauth/accesstoken";
    public static final String API_CONTEXT_OAUTH_USERS = "/context/oauth/users";
    private final String _TAG = "OAuthContextPlugin";
    private String provider;
    private String accessToken;
    private Long expiresAt;
    private IFlybitsOAuthCallback callback;
    private Activity activity;
    private int browserRequestCode;

    private OAuthContextPlugin(Builder builder) {
        this.provider = builder.provider;
        this.accessToken = builder.accessToken;
        this.expiresAt = builder.expiresAt;
        this.activity = builder.activity;
        this.browserRequestCode = builder.browserRequestCode;
        this.callback = builder.callback;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public int getBrowserRequestCode() {
        return this.browserRequestCode;
    }

    public IFlybitsOAuthCallback getCallback() {
        return this.callback;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getProvider() {
        return this.provider;
    }

    @Override
    public void onStart(final Context context) {
        if (this.getAccessToken() == null) {
            String provider = this.getProvider();
            Intent intent = new Intent(context, OAuthLoginBrowserActivity.class);
            intent.putExtra("provider", provider);
            this.getActivity().startActivityForResult(intent, this.getBrowserRequestCode());
        } else {
            final Handler handler = new Handler(Looper.getMainLooper());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessToken token = new AccessToken(OAuthContextPlugin.this.provider, OAuthContextPlugin.this.accessToken, OAuthContextPlugin.this.expiresAt);
                        Result result = FlyAway.post((Context)context, (String)OAuthContextPlugin.API_CONTEXT_OAUTH_ACCESSTOKEN, (String)token.toJson(), null, (String)"OAuthContextPlugin.onStart", null);
                        if (result.getStatus() == RequestStatus.COMPLETED && OAuthContextPlugin.this.getCallback() != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    OAuthContextPlugin.this.getCallback().onOAuthLoginComplete(true, OAuthContextPlugin.this.getAccessToken());
                                }
                            });
                        } else if (OAuthContextPlugin.this.getCallback() != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    OAuthContextPlugin.this.getCallback().onOAuthLoginComplete(false, null);
                                }
                            });
                        }
                    }
                    catch (FlybitsException e) {
                        Logger.exception((String)"OAuthContextPlugin.register", (Exception)((Object)e));
                    }
                }
            });
        }
        Logger.setTag((String)"OAuthContextPlugin").d("Activated OAuth Plugin: " + this.getProvider());
    }

    @Override
    public void onStop(final Context context) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String route = FlybitsAPIConstants.constructGatewayURL((Context)context, (String)OAuthContextPlugin.API_CONTEXT_OAUTH_USERS);
                    String url = String.format(route + "?provider=%s", OAuthContextPlugin.this.provider);
                    Result result = FlyAway.delete((Context)context, (String)url, (String)"OAuthContextPlugin.onStop", null);
                    if (result.getStatus() == RequestStatus.COMPLETED && OAuthContextPlugin.this.getCallback() != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                OAuthContextPlugin.this.getCallback().onOAuthDeleteComplete(true);
                            }
                        });
                        Logger.setTag((String)"OAuthContextPlugin").d("Deactivated: " + OAuthContextPlugin.this.getProvider());
                    } else if (OAuthContextPlugin.this.getCallback() != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                OAuthContextPlugin.this.getCallback().onOAuthDeleteComplete(false);
                            }
                        });
                    }
                }
                catch (FlybitsException e) {
                    Logger.exception((String)"OAuthContextPlugin.unregister", (Exception)((Object)e));
                }
            }
        });
        Logger.setTag((String)"OAuthContextPlugin").d("Deactivated OAuth Plugin: " + this.getProvider());
    }

    @Override
    public void onRefresh(Context context) {
    }

    public static class Builder {
        private String accessToken;
        private long expiresAt;
        private String provider;
        private Activity activity;
        private int browserRequestCode;
        private IFlybitsOAuthCallback callback;

        public Builder(@NonNull String provider, @NonNull Activity activity, int requestCode) {
            this.provider = provider;
            this.activity = activity;
            this.browserRequestCode = requestCode;
        }

        public OAuthContextPlugin build() {
            return new OAuthContextPlugin(this);
        }

        public Builder setAccessToken(@NonNull String accessToken) {
            return this.setAccessToken(accessToken, -1L);
        }

        public Builder setAccessToken(@NonNull String accessToken, long expiresAt) {
            this.accessToken = accessToken;
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder setOAuthBrowserCallback(@NonNull IFlybitsOAuthCallback callback) {
            this.callback = callback;
            return this;
        }
    }
}

