/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.deserializations.DeserializeRule;
import com.flybits.context.models.RuleScope;
import com.flybits.context.models.results.RulesResult;
import com.flybits.context.utils.RuleBuilder;
import com.flybits.context.utils.RulesQueryParameters;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Rule
implements Parcelable {
    public static final String API = "/context/rules";
    private String id;
    private String name;
    private String description;
    private String color;
    private String stringRepresentation;
    private RuleScope scope;
    private String creatorID;
    private boolean defaultEvaluation;
    public static final Parcelable.Creator<Rule> CREATOR = new Parcelable.Creator<Rule>(){

        public Rule createFromParcel(Parcel in) {
            return new Rule(in);
        }

        public Rule[] newArray(int size) {
            return new Rule[size];
        }
    };

    public Rule(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.description = in.readString();
        this.color = in.readString();
        this.stringRepresentation = in.readString();
        this.scope = RuleScope.fromKey(in.readString());
        this.creatorID = in.readString();
        this.defaultEvaluation = in.readInt() == 1;
    }

    public Rule(String id2, String name, String description, String color, String stringRepresentation, String scope, String ownerID, boolean defaultEvaluation) {
        this.id = id2;
        this.name = name;
        this.description = description;
        this.color = color;
        this.stringRepresentation = stringRepresentation;
        this.scope = RuleScope.fromKey(scope);
        this.creatorID = ownerID;
        this.defaultEvaluation = defaultEvaluation;
    }

    public String getColor() {
        return this.color;
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public RuleScope getScope() {
        return this.scope;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public boolean isDefaultEvaluation() {
        return this.defaultEvaluation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return !(this.id == null ? rule.id != null : !this.id.equals(rule.id));
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "[ Id: " + this.id + ", name: " + this.name + " ]";
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.color);
        out.writeString(this.stringRepresentation);
        out.writeString(this.scope.getKey());
        out.writeString(this.creatorID);
        out.writeInt(this.defaultEvaluation ? 1 : 0);
    }

    public static ObjectResult<Rule> create(final @NonNull Context mContext, final @NonNull RuleBuilder newRule, @NonNull ObjectResultCallback<Rule> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult request = new ObjectResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result created = FlyAway.post((Context)mContext, (String)Rule.API, (String)newRule.getRequestBody(), (IDeserializer)new DeserializeRule(), (String)"Rule.create", Rule.class);
                    request.setResult(created);
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public BasicResult delete(final @NonNull Context mContext, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result deleted = FlyAway.delete((Context)mContext, (String)Rule.API, (String)"Rule.delete", (String)Rule.this.id);
                    request.setResult(deleted);
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public static RulesResult get(final @NonNull Context mContext, final @NonNull RulesQueryParameters params, @NonNull PagedResultCallback<Rule> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final RulesResult result = new RulesResult(mContext, params, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeRule singleDeserializaer = new DeserializeRule();
                    DeserializePagedResponse deserializer = new DeserializePagedResponse((IDeserializer)singleDeserializaer);
                    Result getRules = FlyAway.get((Context)mContext, (String)Rule.API, (QueryParameters)params, (IDeserializer)deserializer, (String)"Rule.get");
                    result.setResult(getRules, params);
                }
                catch (FlybitsException e) {
                    result.setFailed(e);
                }
            }
        });
        return result;
    }
}

