/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.flybits.context.db.dao.BasicDataDAO;
import com.flybits.context.models.BasicData;
import java.util.ArrayList;
import java.util.List;

public class BasicDataDAO_Impl
implements BasicDataDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfBasicData;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfBasicData;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfBasicData;

    public BasicDataDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBasicData = new EntityInsertionAdapter<BasicData>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `contextData`(`contextID`,`isSent`,`lastUpdated`,`data`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, BasicData value) {
                if (value.getDataTypeID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDataTypeID());
                }
                int _tmp = value.isSent() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, value.getTimestamp());
                if (value.getValueAsString() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getValueAsString());
                }
            }
        };
        this.__deletionAdapterOfBasicData = new EntityDeletionOrUpdateAdapter<BasicData>(__db){

            public String createQuery() {
                return "DELETE FROM `contextData` WHERE `contextID` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BasicData value) {
                if (value.getDataTypeID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDataTypeID());
                }
            }
        };
        this.__updateAdapterOfBasicData = new EntityDeletionOrUpdateAdapter<BasicData>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `contextData` SET `contextID` = ?,`isSent` = ?,`lastUpdated` = ?,`data` = ? WHERE `contextID` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BasicData value) {
                if (value.getDataTypeID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDataTypeID());
                }
                int _tmp = value.isSent() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                stmt.bindLong(3, value.getTimestamp());
                if (value.getValueAsString() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getValueAsString());
                }
                if (value.getDataTypeID() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getDataTypeID());
                }
            }
        };
    }

    @Override
    public void insert(BasicData plugins) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBasicData.insert((Object)plugins);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(BasicData plugin) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfBasicData.handle((Object)plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(BasicData ... plugin) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfBasicData.handleMultiple((Object[])plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BasicData> getAll() {
        String _sql = "Select * from contextData";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from contextData", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfDataTypeID = _cursor.getColumnIndexOrThrow("contextID");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("lastUpdated");
            int _cursorIndexOfValueAsString = _cursor.getColumnIndexOrThrow("data");
            ArrayList<BasicData> _result = new ArrayList<BasicData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                BasicData _item = new BasicData();
                String _tmpDataTypeID = _cursor.getString(_cursorIndexOfDataTypeID);
                _item.setDataTypeID(_tmpDataTypeID);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp != 0;
                _item.setSent(_tmpIsSent);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                String _tmpValueAsString = _cursor.getString(_cursorIndexOfValueAsString);
                _item.setValueAsString(_tmpValueAsString);
                _result.add(_item);
            }
            ArrayList<BasicData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BasicData> getAllNotSent() {
        String _sql = "Select * from contextData where isSent = 0";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from contextData where isSent = 0", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfDataTypeID = _cursor.getColumnIndexOrThrow("contextID");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("lastUpdated");
            int _cursorIndexOfValueAsString = _cursor.getColumnIndexOrThrow("data");
            ArrayList<BasicData> _result = new ArrayList<BasicData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                BasicData _item = new BasicData();
                String _tmpDataTypeID = _cursor.getString(_cursorIndexOfDataTypeID);
                _item.setDataTypeID(_tmpDataTypeID);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp != 0;
                _item.setSent(_tmpIsSent);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                String _tmpValueAsString = _cursor.getString(_cursorIndexOfValueAsString);
                _item.setValueAsString(_tmpValueAsString);
                _result.add(_item);
            }
            ArrayList<BasicData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicData get(String contextID) {
        String _sql = "Select * from contextData where contextID = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from contextData where contextID = ?", (int)1);
        int _argIndex = 1;
        if (contextID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, contextID);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            BasicData _result;
            int _cursorIndexOfDataTypeID = _cursor.getColumnIndexOrThrow("contextID");
            int _cursorIndexOfIsSent = _cursor.getColumnIndexOrThrow("isSent");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("lastUpdated");
            int _cursorIndexOfValueAsString = _cursor.getColumnIndexOrThrow("data");
            if (_cursor.moveToFirst()) {
                _result = new BasicData();
                String _tmpDataTypeID = _cursor.getString(_cursorIndexOfDataTypeID);
                _result.setDataTypeID(_tmpDataTypeID);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSent);
                boolean _tmpIsSent = _tmp != 0;
                _result.setSent(_tmpIsSent);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
                String _tmpValueAsString = _cursor.getString(_cursorIndexOfValueAsString);
                _result.setValueAsString(_tmpValueAsString);
            } else {
                _result = null;
            }
            BasicData basicData = _result;
            return basicData;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

