package com.flybits.context.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.context.plugins.beacon.BeaconMonitored;
import com.flybits.context.plugins.beacon.BeaconType;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class DeserializeMonitoredBeacons extends IDeserializer<PagedResponse<BeaconMonitored>> {

    @Override
    public String toJson(PagedResponse<BeaconMonitored> obj) {
        return "[]";
    }

    @Override
    public PagedResponse<BeaconMonitored> fromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public PagedResponse<BeaconMonitored> fromJson(JSONArray jsonArray) {
        try {
            ArrayList<BeaconMonitored> beacons = new ArrayList<>();

            for(int i = 0; i < jsonArray.length(); i++)
            {
                JSONObject elementObj = jsonArray.getJSONObject(i);

                BeaconType type = null;
                String identifier   = null;
                if (!elementObj.isNull("type")){
                    type             = BeaconType.fromValue(elementObj.getString("type"));
                }
                if (!elementObj.isNull("monitor")){
                    identifier       = elementObj.getString("monitor");
                }

                beacons.add(new BeaconMonitored(type, identifier));
            }
            return new PagedResponse<>(beacons, new Pagination(beacons.size(), 0, beacons.size()));
        }catch (JSONException | NullPointerException e){
            return null;
        }
    }
}
