package com.flybits.context.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.flybits.context.plugins.beacon.BeaconMonitored;

import java.util.List;

@Dao
public interface BeaconMonitoredDAO {

    @Query("Select * from beaconsMonitored")
    List<BeaconMonitored> getAll();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(BeaconMonitored beacon);

    @Delete
    void delete(BeaconMonitored beacon);

    @Update
    void update(BeaconMonitored... beacons);
}
