package com.flybits.context.plugins;

import android.content.Context;

/**
 * The {@code ContextPlugin} interface is responsible for providing the necessary methods needed to
 * create a valid Flybits Context Plugin. A Context Plugin is responsible for retrieving information
 * about a specific entity whether it's a sensor or 3rd party service.
 */
public interface ContextPlugin {

    /**
     * Start the {@code ContextPlugin} and initialize all the variables that are needed for the
     * {@code ContextPlugin} for successfully start collecting data.
     * TODO: @params
     */
    public void onStart(Context context);

    /**
     * Stop the {@code ContextPlugin} and destroy all the variables that are no longer needed aa the
     * {@code ContextPlugin} is now being deactivated.
     * TODO: @params
     */
    public void onStop(Context context);

    /**
     * If available, refresh the sensor/3rd party data immediately without having to wait for the
     * regular time interval.
     * TODO: @params
     */
    public void onRefresh(Context context);

}
