/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.location;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.location.LocationData;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.util.concurrent.TimeUnit;

public class LocationContextPluginService
extends FlybitsContextPluginService
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private LocationRequest mLocationRequest;
    private GoogleApiClient mGoogleApiClient;
    private static final String _TAG = "PluginLocation";
    private long minDisplacement = -1L;

    @Override
    public void initialize(Bundle bundle) {
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            if (bundle != null && bundle.containsKey("minDisplacement")) {
                this.minDisplacement = bundle.getLong("minDisplacement");
            }
        }
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)this.getBaseContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    @Override
    public ContextData getData() {
        Logger.setTag((String)_TAG).d("Fetching Data ...");
        if (this.mGoogleApiClient != null) {
            Location mLastLocation;
            if (!this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.blockingConnect(10L, TimeUnit.SECONDS);
            }
            if (!this.mGoogleApiClient.isConnected()) {
                this.wait(10L, TimeUnit.SECONDS);
            }
            if (this.mGoogleApiClient.isConnected() && (mLastLocation = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient)) != null) {
                Logger.setTag((String)_TAG).d("Last Known Location: " + mLastLocation);
                return new LocationData(mLastLocation);
            }
        }
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected() && this.isSupported()) {
            Logger.setTag((String)_TAG).d("Google API Services connected!");
            this.mLocationRequest = LocationRequest.create().setPriority(100).setInterval(this.getRefreshTime() * 1000L);
            if (this.minDisplacement > 10L) {
                this.mLocationRequest.setSmallestDisplacement((float)this.minDisplacement);
            }
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, this.mLocationRequest, (LocationListener)this);
        }
    }

    public void onConnectionSuspended(int i) {
        Logger.setTag((String)_TAG).w("GoogleAPIClient: onConnectionSuspended: " + i);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                LocationContextPluginService.this.mGoogleApiClient.connect();
            }
        }, 1000L);
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Logger.setTag((String)_TAG).e("GoogleAPIClient: onConnectionFailed: + " + connectionResult);
    }

    public void onLocationChanged(Location location) {
        Logger.setTag((String)_TAG).d("On Location Changed: " + location + ", " + location.getProvider());
        LocationData data = new LocationData(location);
        long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
        data.update(this.getBaseContext(), timeInSec, null);
    }

    @Override
    public void onDestroy() {
        Logger.setTag((String)_TAG).d("...Destroyed");
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
            this.mGoogleApiClient.disconnect();
        }
        super.onDestroy();
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    }

    public GoogleApiClient getGoogleApiClient() {
        return this.mGoogleApiClient;
    }
}

