/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.library.R;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;

public class OAuthLoginBrowserActivity
extends Activity {
    private final String _TAG = "OAuthLoginBrowserActivity";
    final String API_CONTEXT_OAUTH = "/context/oauth";
    public static final int RESULT_ACCESS_DENIED = 2;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String provider = null;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            provider = bundle.getString("provider");
        } else {
            this.finish();
        }
        this.setContentView(R.layout.activity_web);
        WebView myWebView = (WebView)this.findViewById(R.id.web_flybits_browser);
        WebSettings webSettings = myWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        myWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Uri uri = OAuthLoginBrowserActivity.isFlybitsURLBeingAccessed((Context)OAuthLoginBrowserActivity.this, url);
                if (uri != null) {
                    Logger.setTag((String)"OAuthLoginBrowserActivity").d("Successfully Logged In");
                    Intent resultIntent = new Intent();
                    int resultCode = OAuthLoginBrowserActivity.getResultCode(uri);
                    if (resultCode == 2) {
                        resultIntent.putExtra("error", uri.getQueryParameter("error"));
                    }
                    OAuthLoginBrowserActivity.this.setResult(resultCode, resultIntent);
                    OAuthLoginBrowserActivity.this.finish();
                }
                view.loadUrl(url, OAuthLoginBrowserActivity.getHeaders((Context)OAuthLoginBrowserActivity.this));
                return true;
            }
        });
        String url = String.format(FlybitsAPIConstants.constructGatewayURL((Context)this, (String)"/context/oauth") + "?provider=%s", provider);
        myWebView.loadUrl(url, OAuthLoginBrowserActivity.getHeaders((Context)this));
    }

    static Uri isFlybitsURLBeingAccessed(Context context, String url) {
        try {
            URL urlObj = new URL(url);
            Uri uri = Uri.parse((String)urlObj.toURI().toString());
            if (OAuthLoginBrowserActivity.startsWithFlybitsAPI(context, uri) && uri.getQueryParameter("provider") != null) {
                return uri;
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            Logger.exception((String)"OAuthLoginBrowserActivity.isFlybitsURLBeingAccessed", (Exception)exception);
        }
        return null;
    }

    static HashMap<String, String> getHeaders(Context context) {
        HashMap<String, String> listOfHeaders = new HashMap<String, String>();
        listOfHeaders.put("X-Authorization", SharedElements.INSTANCE.getSavedJWTToken());
        return listOfHeaders;
    }

    static boolean startsWithFlybitsAPI(Context context, Uri uri) {
        return uri != null && uri.toString().startsWith(FlybitsAPIConstants.getGatewayURL((Context)context));
    }

    static int getResultCode(Uri uri) {
        if (uri.getQueryParameter("error") != null && !uri.getQueryParameter("error").isEmpty()) {
            return 2;
        }
        return -1;
    }
}

